/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plan;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.optimizer.costs.Costs;
import org.apache.flink.optimizer.dag.BinaryUnionNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.util.IterableIterator;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public class NAryUnionPlanNode
extends PlanNode {
    private final List<Channel> inputs;

    public NAryUnionPlanNode(BinaryUnionNode template, List<Channel> inputs, GlobalProperties gProps, Costs cumulativeCosts) {
        super(template, "Union", DriverStrategy.NONE);
        this.inputs = inputs;
        this.globalProps = gProps;
        this.localProps = new LocalProperties();
        this.nodeCosts = new Costs();
        this.cumulativeCosts = cumulativeCosts;
    }

    public void accept(Visitor<PlanNode> visitor) {
        visitor.preVisit((Visitable)this);
        for (Channel c : this.inputs) {
            c.getSource().accept(visitor);
        }
        visitor.postVisit((Visitable)this);
    }

    public List<Channel> getListOfInputs() {
        return this.inputs;
    }

    @Override
    public Iterable<Channel> getInputs() {
        return Collections.unmodifiableList(this.inputs);
    }

    @Override
    public Iterable<PlanNode> getPredecessors() {
        final Iterator<Channel> channels = this.inputs.iterator();
        return new IterableIterator<PlanNode>(){

            public boolean hasNext() {
                return channels.hasNext();
            }

            public PlanNode next() {
                return ((Channel)channels.next()).getSource();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Iterator<PlanNode> iterator() {
                return this;
            }
        };
    }

    @Override
    public PlanNode.SourceAndDamReport hasDamOnPathDownTo(PlanNode source) {
        throw new UnsupportedOperationException();
    }
}

