/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.status;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.fabric8.crd.generator.annotation.PrinterColumn;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.Diffable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Experimental
public class FlinkStateSnapshotStatus
implements Diffable<FlinkStateSnapshotStatus> {
    @PrinterColumn(name="Snapshot State")
    private State state = State.TRIGGER_PENDING;
    private String triggerId;
    private String triggerTimestamp;
    @PrinterColumn(name="Result Timestamp")
    private String resultTimestamp;
    @PrinterColumn(name="Path")
    private String path;
    private String error;
    private int failures = 0;

    protected FlinkStateSnapshotStatus(FlinkStateSnapshotStatusBuilder<?, ?> b) {
        this.state = b.state;
        this.triggerId = b.triggerId;
        this.triggerTimestamp = b.triggerTimestamp;
        this.resultTimestamp = b.resultTimestamp;
        this.path = b.path;
        this.error = b.error;
        this.failures = b.failures;
    }

    public static FlinkStateSnapshotStatusBuilder<?, ?> builder() {
        return new FlinkStateSnapshotStatusBuilderImpl();
    }

    public FlinkStateSnapshotStatusBuilder<?, ?> toBuilder() {
        return new FlinkStateSnapshotStatusBuilderImpl().$fillValuesFrom(this);
    }

    public State getState() {
        return this.state;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getTriggerTimestamp() {
        return this.triggerTimestamp;
    }

    public String getResultTimestamp() {
        return this.resultTimestamp;
    }

    public String getPath() {
        return this.path;
    }

    public String getError() {
        return this.error;
    }

    public int getFailures() {
        return this.failures;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setTriggerTimestamp(String triggerTimestamp) {
        this.triggerTimestamp = triggerTimestamp;
    }

    public void setResultTimestamp(String resultTimestamp) {
        this.resultTimestamp = resultTimestamp;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setError(String error) {
        this.error = error;
    }

    public void setFailures(int failures) {
        this.failures = failures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkStateSnapshotStatus)) {
            return false;
        }
        FlinkStateSnapshotStatus other = (FlinkStateSnapshotStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFailures() != other.getFailures()) {
            return false;
        }
        State this$state = this.getState();
        State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        String this$triggerTimestamp = this.getTriggerTimestamp();
        String other$triggerTimestamp = other.getTriggerTimestamp();
        if (this$triggerTimestamp == null ? other$triggerTimestamp != null : !this$triggerTimestamp.equals(other$triggerTimestamp)) {
            return false;
        }
        String this$resultTimestamp = this.getResultTimestamp();
        String other$resultTimestamp = other.getResultTimestamp();
        if (this$resultTimestamp == null ? other$resultTimestamp != null : !this$resultTimestamp.equals(other$resultTimestamp)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlinkStateSnapshotStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFailures();
        State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        String $triggerTimestamp = this.getTriggerTimestamp();
        result = result * 59 + ($triggerTimestamp == null ? 43 : $triggerTimestamp.hashCode());
        String $resultTimestamp = this.getResultTimestamp();
        result = result * 59 + ($resultTimestamp == null ? 43 : $resultTimestamp.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }

    public String toString() {
        return "FlinkStateSnapshotStatus(state=" + this.getState() + ", triggerId=" + this.getTriggerId() + ", triggerTimestamp=" + this.getTriggerTimestamp() + ", resultTimestamp=" + this.getResultTimestamp() + ", path=" + this.getPath() + ", error=" + this.getError() + ", failures=" + this.getFailures() + ")";
    }

    public FlinkStateSnapshotStatus(State state, String triggerId, String triggerTimestamp, String resultTimestamp, String path, String error, int failures) {
        this.state = state;
        this.triggerId = triggerId;
        this.triggerTimestamp = triggerTimestamp;
        this.resultTimestamp = resultTimestamp;
        this.path = path;
        this.error = error;
        this.failures = failures;
    }

    public FlinkStateSnapshotStatus() {
    }

    private static final class FlinkStateSnapshotStatusBuilderImpl
    extends FlinkStateSnapshotStatusBuilder<FlinkStateSnapshotStatus, FlinkStateSnapshotStatusBuilderImpl> {
        private FlinkStateSnapshotStatusBuilderImpl() {
        }

        @Override
        protected FlinkStateSnapshotStatusBuilderImpl self() {
            return this;
        }

        @Override
        public FlinkStateSnapshotStatus build() {
            return new FlinkStateSnapshotStatus(this);
        }
    }

    public static abstract class FlinkStateSnapshotStatusBuilder<C extends FlinkStateSnapshotStatus, B extends FlinkStateSnapshotStatusBuilder<C, B>> {
        private State state;
        private String triggerId;
        private String triggerTimestamp;
        private String resultTimestamp;
        private String path;
        private String error;
        private int failures;

        protected B $fillValuesFrom(C instance) {
            FlinkStateSnapshotStatusBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(FlinkStateSnapshotStatus instance, FlinkStateSnapshotStatusBuilder<?, ?> b) {
            b.state(instance.state);
            b.triggerId(instance.triggerId);
            b.triggerTimestamp(instance.triggerTimestamp);
            b.resultTimestamp(instance.resultTimestamp);
            b.path(instance.path);
            b.error(instance.error);
            b.failures(instance.failures);
        }

        public B state(State state) {
            this.state = state;
            return this.self();
        }

        public B triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this.self();
        }

        public B triggerTimestamp(String triggerTimestamp) {
            this.triggerTimestamp = triggerTimestamp;
            return this.self();
        }

        public B resultTimestamp(String resultTimestamp) {
            this.resultTimestamp = resultTimestamp;
            return this.self();
        }

        public B path(String path) {
            this.path = path;
            return this.self();
        }

        public B error(String error) {
            this.error = error;
            return this.self();
        }

        public B failures(int failures) {
            this.failures = failures;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "FlinkStateSnapshotStatus.FlinkStateSnapshotStatusBuilder(state=" + this.state + ", triggerId=" + this.triggerId + ", triggerTimestamp=" + this.triggerTimestamp + ", resultTimestamp=" + this.resultTimestamp + ", path=" + this.path + ", error=" + this.error + ", failures=" + this.failures + ")";
        }
    }

    @Experimental
    public static enum State {
        COMPLETED,
        FAILED,
        IN_PROGRESS,
        TRIGGER_PENDING,
        ABANDONED;

    }
}

