/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.status;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.status.Checkpoint;
import org.apache.flink.kubernetes.operator.api.status.CheckpointType;
import org.apache.flink.kubernetes.operator.api.status.Snapshot;
import org.apache.flink.kubernetes.operator.api.status.SnapshotInfo;
import org.apache.flink.kubernetes.operator.api.status.SnapshotTriggerType;

@Deprecated
@Experimental
public class CheckpointInfo
implements SnapshotInfo {
    private Checkpoint lastCheckpoint;
    private String triggerId;
    private Long triggerTimestamp;
    private SnapshotTriggerType triggerType;
    private CheckpointType formatType;
    private long lastPeriodicCheckpointTimestamp = 0L;

    public void setTrigger(String triggerId, SnapshotTriggerType triggerType, CheckpointType formatType) {
        this.triggerId = triggerId;
        this.triggerTimestamp = System.currentTimeMillis();
        this.triggerType = triggerType;
        this.formatType = formatType;
    }

    @Override
    public void resetTrigger() {
        this.triggerId = null;
        this.triggerTimestamp = null;
        this.triggerType = null;
        this.formatType = null;
    }

    public void updateLastCheckpoint(Checkpoint checkpoint) {
        this.lastCheckpoint = checkpoint;
        if (checkpoint.getTriggerType() == SnapshotTriggerType.PERIODIC) {
            this.lastPeriodicCheckpointTimestamp = checkpoint.getTimeStamp();
        }
        this.resetTrigger();
    }

    @Override
    @JsonIgnore
    public Long getLastTriggerNonce() {
        return this.lastCheckpoint == null ? null : this.lastCheckpoint.getTriggerNonce();
    }

    @Override
    @JsonIgnore
    public long getLastPeriodicTriggerTimestamp() {
        return this.lastPeriodicCheckpointTimestamp;
    }

    @Override
    @JsonIgnore
    public SnapshotTriggerType getLastTriggerType() {
        return this.lastCheckpoint == null ? null : this.lastCheckpoint.getTriggerType();
    }

    @Override
    @JsonIgnore
    public String formatErrorMessage(Long triggerNonce) {
        return SnapshotTriggerType.PERIODIC == this.triggerType ? "Periodic checkpoint failed" : "Checkpoint failed for checkpointTriggerNonce: " + triggerNonce;
    }

    @Override
    @JsonIgnore
    public Snapshot getLastSnapshot() {
        return this.lastCheckpoint;
    }

    public static CheckpointInfoBuilder builder() {
        return new CheckpointInfoBuilder();
    }

    public Checkpoint getLastCheckpoint() {
        return this.lastCheckpoint;
    }

    @Override
    public String getTriggerId() {
        return this.triggerId;
    }

    @Override
    public Long getTriggerTimestamp() {
        return this.triggerTimestamp;
    }

    @Override
    public SnapshotTriggerType getTriggerType() {
        return this.triggerType;
    }

    public CheckpointType getFormatType() {
        return this.formatType;
    }

    public long getLastPeriodicCheckpointTimestamp() {
        return this.lastPeriodicCheckpointTimestamp;
    }

    public void setLastCheckpoint(Checkpoint lastCheckpoint) {
        this.lastCheckpoint = lastCheckpoint;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public void setTriggerTimestamp(Long triggerTimestamp) {
        this.triggerTimestamp = triggerTimestamp;
    }

    public void setTriggerType(SnapshotTriggerType triggerType) {
        this.triggerType = triggerType;
    }

    public void setFormatType(CheckpointType formatType) {
        this.formatType = formatType;
    }

    public void setLastPeriodicCheckpointTimestamp(long lastPeriodicCheckpointTimestamp) {
        this.lastPeriodicCheckpointTimestamp = lastPeriodicCheckpointTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointInfo)) {
            return false;
        }
        CheckpointInfo other = (CheckpointInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLastPeriodicCheckpointTimestamp() != other.getLastPeriodicCheckpointTimestamp()) {
            return false;
        }
        Long this$triggerTimestamp = this.getTriggerTimestamp();
        Long other$triggerTimestamp = other.getTriggerTimestamp();
        if (this$triggerTimestamp == null ? other$triggerTimestamp != null : !((Object)this$triggerTimestamp).equals(other$triggerTimestamp)) {
            return false;
        }
        Checkpoint this$lastCheckpoint = this.getLastCheckpoint();
        Checkpoint other$lastCheckpoint = other.getLastCheckpoint();
        if (this$lastCheckpoint == null ? other$lastCheckpoint != null : !((Object)this$lastCheckpoint).equals(other$lastCheckpoint)) {
            return false;
        }
        String this$triggerId = this.getTriggerId();
        String other$triggerId = other.getTriggerId();
        if (this$triggerId == null ? other$triggerId != null : !this$triggerId.equals(other$triggerId)) {
            return false;
        }
        SnapshotTriggerType this$triggerType = this.getTriggerType();
        SnapshotTriggerType other$triggerType = other.getTriggerType();
        if (this$triggerType == null ? other$triggerType != null : !((Object)((Object)this$triggerType)).equals((Object)other$triggerType)) {
            return false;
        }
        CheckpointType this$formatType = this.getFormatType();
        CheckpointType other$formatType = other.getFormatType();
        return !(this$formatType == null ? other$formatType != null : !((Object)((Object)this$formatType)).equals((Object)other$formatType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckpointInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastPeriodicCheckpointTimestamp = this.getLastPeriodicCheckpointTimestamp();
        result = result * 59 + (int)($lastPeriodicCheckpointTimestamp >>> 32 ^ $lastPeriodicCheckpointTimestamp);
        Long $triggerTimestamp = this.getTriggerTimestamp();
        result = result * 59 + ($triggerTimestamp == null ? 43 : ((Object)$triggerTimestamp).hashCode());
        Checkpoint $lastCheckpoint = this.getLastCheckpoint();
        result = result * 59 + ($lastCheckpoint == null ? 43 : ((Object)$lastCheckpoint).hashCode());
        String $triggerId = this.getTriggerId();
        result = result * 59 + ($triggerId == null ? 43 : $triggerId.hashCode());
        SnapshotTriggerType $triggerType = this.getTriggerType();
        result = result * 59 + ($triggerType == null ? 43 : ((Object)((Object)$triggerType)).hashCode());
        CheckpointType $formatType = this.getFormatType();
        result = result * 59 + ($formatType == null ? 43 : ((Object)((Object)$formatType)).hashCode());
        return result;
    }

    public String toString() {
        return "CheckpointInfo(lastCheckpoint=" + this.getLastCheckpoint() + ", triggerId=" + this.getTriggerId() + ", triggerTimestamp=" + this.getTriggerTimestamp() + ", triggerType=" + this.getTriggerType() + ", formatType=" + this.getFormatType() + ", lastPeriodicCheckpointTimestamp=" + this.getLastPeriodicCheckpointTimestamp() + ")";
    }

    public CheckpointInfo() {
    }

    public CheckpointInfo(Checkpoint lastCheckpoint, String triggerId, Long triggerTimestamp, SnapshotTriggerType triggerType, CheckpointType formatType, long lastPeriodicCheckpointTimestamp) {
        this.lastCheckpoint = lastCheckpoint;
        this.triggerId = triggerId;
        this.triggerTimestamp = triggerTimestamp;
        this.triggerType = triggerType;
        this.formatType = formatType;
        this.lastPeriodicCheckpointTimestamp = lastPeriodicCheckpointTimestamp;
    }

    public static class CheckpointInfoBuilder {
        private Checkpoint lastCheckpoint;
        private String triggerId;
        private Long triggerTimestamp;
        private SnapshotTriggerType triggerType;
        private CheckpointType formatType;
        private long lastPeriodicCheckpointTimestamp;

        CheckpointInfoBuilder() {
        }

        public CheckpointInfoBuilder lastCheckpoint(Checkpoint lastCheckpoint) {
            this.lastCheckpoint = lastCheckpoint;
            return this;
        }

        public CheckpointInfoBuilder triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this;
        }

        public CheckpointInfoBuilder triggerTimestamp(Long triggerTimestamp) {
            this.triggerTimestamp = triggerTimestamp;
            return this;
        }

        public CheckpointInfoBuilder triggerType(SnapshotTriggerType triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        public CheckpointInfoBuilder formatType(CheckpointType formatType) {
            this.formatType = formatType;
            return this;
        }

        public CheckpointInfoBuilder lastPeriodicCheckpointTimestamp(long lastPeriodicCheckpointTimestamp) {
            this.lastPeriodicCheckpointTimestamp = lastPeriodicCheckpointTimestamp;
            return this;
        }

        public CheckpointInfo build() {
            return new CheckpointInfo(this.lastCheckpoint, this.triggerId, this.triggerTimestamp, this.triggerType, this.formatType, this.lastPeriodicCheckpointTimestamp);
        }

        public String toString() {
            return "CheckpointInfo.CheckpointInfoBuilder(lastCheckpoint=" + this.lastCheckpoint + ", triggerId=" + this.triggerId + ", triggerTimestamp=" + this.triggerTimestamp + ", triggerType=" + this.triggerType + ", formatType=" + this.formatType + ", lastPeriodicCheckpointTimestamp=" + this.lastPeriodicCheckpointTimestamp + ")";
        }
    }
}

