/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.operator.api.spec;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.kubernetes.operator.api.diff.Diffable;
import org.apache.flink.kubernetes.operator.api.spec.CheckpointSpec;
import org.apache.flink.kubernetes.operator.api.spec.JobReference;
import org.apache.flink.kubernetes.operator.api.spec.SavepointSpec;

@JsonIgnoreProperties(ignoreUnknown=true)
@Experimental
public class FlinkStateSnapshotSpec
implements Diffable<FlinkStateSnapshotSpec> {
    private JobReference jobReference;
    private SavepointSpec savepoint = null;
    private CheckpointSpec checkpoint = null;
    private int backoffLimit = -1;

    public boolean isSavepoint() {
        return this.savepoint != null;
    }

    public boolean isCheckpoint() {
        return this.checkpoint != null;
    }

    protected FlinkStateSnapshotSpec(FlinkStateSnapshotSpecBuilder<?, ?> b) {
        this.jobReference = b.jobReference;
        this.savepoint = b.savepoint;
        this.checkpoint = b.checkpoint;
        this.backoffLimit = b.backoffLimit;
    }

    public static FlinkStateSnapshotSpecBuilder<?, ?> builder() {
        return new FlinkStateSnapshotSpecBuilderImpl();
    }

    public JobReference getJobReference() {
        return this.jobReference;
    }

    public SavepointSpec getSavepoint() {
        return this.savepoint;
    }

    public CheckpointSpec getCheckpoint() {
        return this.checkpoint;
    }

    public int getBackoffLimit() {
        return this.backoffLimit;
    }

    public void setJobReference(JobReference jobReference) {
        this.jobReference = jobReference;
    }

    public void setSavepoint(SavepointSpec savepoint) {
        this.savepoint = savepoint;
    }

    public void setCheckpoint(CheckpointSpec checkpoint) {
        this.checkpoint = checkpoint;
    }

    public void setBackoffLimit(int backoffLimit) {
        this.backoffLimit = backoffLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkStateSnapshotSpec)) {
            return false;
        }
        FlinkStateSnapshotSpec other = (FlinkStateSnapshotSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBackoffLimit() != other.getBackoffLimit()) {
            return false;
        }
        JobReference this$jobReference = this.getJobReference();
        JobReference other$jobReference = other.getJobReference();
        if (this$jobReference == null ? other$jobReference != null : !((Object)this$jobReference).equals(other$jobReference)) {
            return false;
        }
        SavepointSpec this$savepoint = this.getSavepoint();
        SavepointSpec other$savepoint = other.getSavepoint();
        if (this$savepoint == null ? other$savepoint != null : !((Object)this$savepoint).equals(other$savepoint)) {
            return false;
        }
        CheckpointSpec this$checkpoint = this.getCheckpoint();
        CheckpointSpec other$checkpoint = other.getCheckpoint();
        return !(this$checkpoint == null ? other$checkpoint != null : !((Object)this$checkpoint).equals(other$checkpoint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlinkStateSnapshotSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBackoffLimit();
        JobReference $jobReference = this.getJobReference();
        result = result * 59 + ($jobReference == null ? 43 : ((Object)$jobReference).hashCode());
        SavepointSpec $savepoint = this.getSavepoint();
        result = result * 59 + ($savepoint == null ? 43 : ((Object)$savepoint).hashCode());
        CheckpointSpec $checkpoint = this.getCheckpoint();
        result = result * 59 + ($checkpoint == null ? 43 : ((Object)$checkpoint).hashCode());
        return result;
    }

    public String toString() {
        return "FlinkStateSnapshotSpec(jobReference=" + this.getJobReference() + ", savepoint=" + this.getSavepoint() + ", checkpoint=" + this.getCheckpoint() + ", backoffLimit=" + this.getBackoffLimit() + ")";
    }

    public FlinkStateSnapshotSpec() {
    }

    public FlinkStateSnapshotSpec(JobReference jobReference, SavepointSpec savepoint, CheckpointSpec checkpoint, int backoffLimit) {
        this.jobReference = jobReference;
        this.savepoint = savepoint;
        this.checkpoint = checkpoint;
        this.backoffLimit = backoffLimit;
    }

    private static final class FlinkStateSnapshotSpecBuilderImpl
    extends FlinkStateSnapshotSpecBuilder<FlinkStateSnapshotSpec, FlinkStateSnapshotSpecBuilderImpl> {
        private FlinkStateSnapshotSpecBuilderImpl() {
        }

        @Override
        protected FlinkStateSnapshotSpecBuilderImpl self() {
            return this;
        }

        @Override
        public FlinkStateSnapshotSpec build() {
            return new FlinkStateSnapshotSpec(this);
        }
    }

    public static abstract class FlinkStateSnapshotSpecBuilder<C extends FlinkStateSnapshotSpec, B extends FlinkStateSnapshotSpecBuilder<C, B>> {
        private JobReference jobReference;
        private SavepointSpec savepoint;
        private CheckpointSpec checkpoint;
        private int backoffLimit;

        public B jobReference(JobReference jobReference) {
            this.jobReference = jobReference;
            return this.self();
        }

        public B savepoint(SavepointSpec savepoint) {
            this.savepoint = savepoint;
            return this.self();
        }

        public B checkpoint(CheckpointSpec checkpoint) {
            this.checkpoint = checkpoint;
            return this.self();
        }

        public B backoffLimit(int backoffLimit) {
            this.backoffLimit = backoffLimit;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "FlinkStateSnapshotSpec.FlinkStateSnapshotSpecBuilder(jobReference=" + this.jobReference + ", savepoint=" + this.savepoint + ", checkpoint=" + this.checkpoint + ", backoffLimit=" + this.backoffLimit + ")";
        }
    }
}

