/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sca;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.sca.CodeAnalyzerException;
import org.apache.flink.api.java.sca.ModifiedASMAnalyzer;
import org.apache.flink.api.java.sca.ModifiedASMFrame;
import org.apache.flink.api.java.sca.TaggedValue;
import org.apache.flink.api.java.sca.UdfAnalyzer;
import org.apache.flink.api.java.sca.UdfAnalyzerUtils;
import org.apache.flink.shaded.asm5.org.objectweb.asm.Type;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.AbstractInsnNode;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.FieldInsnNode;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.IntInsnNode;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.LdcInsnNode;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.MethodInsnNode;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.MethodNode;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.TypeInsnNode;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.analysis.BasicValue;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.analysis.Interpreter;
import org.apache.flink.shaded.asm5.org.objectweb.asm.tree.analysis.Value;

@Internal
public class NestedMethodAnalyzer
extends BasicInterpreter {
    private final UdfAnalyzer analyzer;
    private final boolean topLevelMethod;
    private final String owner;
    private final MethodNode methodNode;
    private final List<BasicValue> argumentValues;
    private final int remainingNesting;
    private ModifiedASMAnalyzer modifiedAsmAnalyzer;
    private int curArgIndex = -1;
    private List<TaggedValue> returnValues = new ArrayList<TaggedValue>();
    ModifiedASMFrame currentFrame;
    boolean rightMergePriority;

    public NestedMethodAnalyzer(UdfAnalyzer analyzer, String owner, MethodNode methodNode, List<BasicValue> argumentValues, int remainingNesting, boolean topLevelMethod) {
        this.analyzer = analyzer;
        this.topLevelMethod = topLevelMethod;
        this.owner = owner;
        this.methodNode = methodNode;
        this.argumentValues = argumentValues;
        this.remainingNesting = remainingNesting;
        if (remainingNesting < 0) {
            throw new CodeAnalyzerException("Maximum nesting level reached.");
        }
    }

    public TaggedValue analyze() throws AnalyzerException {
        this.modifiedAsmAnalyzer = new ModifiedASMAnalyzer((Interpreter)this);
        this.modifiedAsmAnalyzer.analyze(this.owner, this.methodNode);
        return UdfAnalyzerUtils.mergeReturnValues(this.returnValues);
    }

    private TaggedValue invokeNestedMethod(List<? extends BasicValue> values, MethodInsnNode methodInsn) throws AnalyzerException {
        Object[] mn = UdfAnalyzerUtils.findMethodNode(methodInsn.owner, methodInsn.name, methodInsn.desc);
        MethodNode methodNode = (MethodNode)mn[0];
        if (methodNode.name.equals(this.methodNode.name) && methodNode.desc.equals(this.methodNode.desc)) {
            return UdfAnalyzerUtils.mergeReturnValues(this.returnValues);
        }
        NestedMethodAnalyzer nma = new NestedMethodAnalyzer(this.analyzer, (String)mn[1], (MethodNode)mn[0], values, this.remainingNesting - 1, this.topLevelMethod && this.isBridgeMethod());
        return nma.analyze();
    }

    private boolean isBridgeMethod() {
        return (this.methodNode.access & 0x40) == 64;
    }

    private boolean isGetRuntimeContext(MethodInsnNode methodInsnNode) {
        return methodInsnNode.name.equals("getRuntimeContext") && UdfAnalyzerUtils.findMethodNode(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc)[1].equals("org/apache/flink/api/common/functions/AbstractRichFunction");
    }

    private Type checkForUnboxing(String name, String methodOwner) {
        if (!methodOwner.startsWith("java/lang/") || !name.endsWith("Value")) {
            return null;
        }
        String actualType = methodOwner.substring(10);
        String convertedType = name.substring(0, name.length() - 5);
        if (convertedType.equals("byte") && actualType.equals("Byte")) {
            return Type.BYTE_TYPE;
        }
        if (convertedType.equals("short") && actualType.equals("Short")) {
            return Type.SHORT_TYPE;
        }
        if (convertedType.equals("int") && actualType.equals("Integer")) {
            return Type.INT_TYPE;
        }
        if (convertedType.equals("long") && actualType.equals("Long")) {
            return Type.LONG_TYPE;
        }
        if (convertedType.equals("boolean") && actualType.equals("Boolean")) {
            return Type.BOOLEAN_TYPE;
        }
        if (convertedType.equals("char") && actualType.equals("Character")) {
            return Type.CHAR_TYPE;
        }
        if (convertedType.equals("float") && actualType.equals("Float")) {
            return Type.FLOAT_TYPE;
        }
        if (convertedType.equals("double") && actualType.equals("Double")) {
            return Type.DOUBLE_TYPE;
        }
        return null;
    }

    private Type checkForBoxing(String name, String desc, String methodOwner) {
        if (!methodOwner.startsWith("java/lang/") || !name.equals("valueOf")) {
            return null;
        }
        String convertedType = methodOwner.substring(10);
        if (convertedType.equals("Byte") && desc.equals("(B)Ljava/lang/Byte;")) {
            return Type.BYTE_TYPE;
        }
        if (convertedType.equals("Short") && desc.equals("(S)Ljava/lang/Short;")) {
            return Type.SHORT_TYPE;
        }
        if (convertedType.equals("Integer") && desc.equals("(I)Ljava/lang/Integer;")) {
            return Type.INT_TYPE;
        }
        if (convertedType.equals("Long") && desc.equals("(J)Ljava/lang/Long;")) {
            return Type.LONG_TYPE;
        }
        if (convertedType.equals("Boolean") && desc.equals("(Z)Ljava/lang/Boolean;")) {
            return Type.BOOLEAN_TYPE;
        }
        if (convertedType.equals("Character") && desc.equals("(C)Ljava/lang/Character;")) {
            return Type.CHAR_TYPE;
        }
        if (convertedType.equals("Float") && desc.equals("(F)Ljava/lang/Float;")) {
            return Type.FLOAT_TYPE;
        }
        if (convertedType.equals("Double") && desc.equals("(D)Ljava/lang/Double;")) {
            return Type.DOUBLE_TYPE;
        }
        return null;
    }

    public BasicValue newValue(Type type) {
        switch (this.analyzer.getState()) {
            case 0: {
                this.analyzer.setState(1);
                ++this.curArgIndex;
                return super.newValue(type);
            }
            case 1: {
                this.analyzer.setState(2);
                TaggedValue tv = new TaggedValue(type, TaggedValue.Tag.THIS);
                ++this.curArgIndex;
                return tv;
            }
            case 2: {
                if (this.analyzer.isUdfBinary() || this.analyzer.isUdfReduceFunction()) {
                    this.analyzer.setState(3);
                } else if (this.analyzer.hasUdfCollector()) {
                    this.analyzer.setState(4);
                } else {
                    this.analyzer.setState(5);
                }
                TaggedValue tv = this.analyzer.hasUdfIterableInput() ? new TaggedValue(type, TaggedValue.Tag.INPUT_1_ITERABLE) : this.analyzer.getInput1AsTaggedValue();
                ++this.curArgIndex;
                return tv;
            }
            case 3: {
                if (this.analyzer.hasUdfCollector()) {
                    this.analyzer.setState(4);
                } else {
                    this.analyzer.setState(5);
                }
                TaggedValue tv = this.analyzer.hasUdfIterableInput() ? new TaggedValue(type, TaggedValue.Tag.INPUT_2_ITERABLE) : (this.analyzer.isUdfReduceFunction() ? this.analyzer.getInput1AsTaggedValue() : this.analyzer.getInput2AsTaggedValue());
                ++this.curArgIndex;
                return tv;
            }
            case 4: {
                this.analyzer.setState(5);
                TaggedValue tv = new TaggedValue(type, TaggedValue.Tag.COLLECTOR);
                ++this.curArgIndex;
                return tv;
            }
        }
        if (this.curArgIndex < 0) {
            ++this.curArgIndex;
        } else if (this.argumentValues != null && this.curArgIndex < this.argumentValues.size()) {
            return this.argumentValues.get(this.curArgIndex++);
        }
        return super.newValue(type);
    }

    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 1: {
                return new TaggedValue(Type.getObjectType((String)"null"), TaggedValue.Tag.NULL);
            }
            case 187: {
                this.analyzer.incrNewOperationCounters(this.topLevelMethod);
                return new TaggedValue(Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
            case 16: 
            case 17: {
                IntInsnNode intInsn = (IntInsnNode)insn;
                return new TaggedValue(intInsn.operand);
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return new TaggedValue((Integer)cst);
                }
                return super.newOperation(insn);
            }
            case 2: {
                return new TaggedValue(-1);
            }
            case 3: {
                return new TaggedValue(0);
            }
            case 4: {
                return new TaggedValue(1);
            }
            case 5: {
                return new TaggedValue(2);
            }
            case 6: {
                return new TaggedValue(3);
            }
            case 7: {
                return new TaggedValue(4);
            }
            case 8: {
                return new TaggedValue(5);
            }
        }
        return super.newOperation(insn);
    }

    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 21: {
                if (UdfAnalyzerUtils.isTagged((Value)value) && UdfAnalyzerUtils.tagged((Value)value).isIntConstant()) {
                    UdfAnalyzerUtils.tagged((Value)value).makeRegular();
                }
                return super.copyOperation(insn, value);
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                if (UdfAnalyzerUtils.isTagged((Value)value) && UdfAnalyzerUtils.tagged((Value)value).isInput() && UdfAnalyzerUtils.tagged((Value)value).isCallByValue()) {
                    return UdfAnalyzerUtils.tagged((Value)value).copy();
                }
                return super.copyOperation(insn, value);
            }
        }
        return super.copyOperation(insn, value);
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 153: {
                if (UdfAnalyzerUtils.isTagged((Value)value) && UdfAnalyzerUtils.tagged((Value)value).isIteratorTrueAssumption()) {
                    this.modifiedAsmAnalyzer.requestIFEQLoopModification();
                }
                return super.unaryOperation(insn, value);
            }
            case 154: {
                if (UdfAnalyzerUtils.isTagged((Value)value) && UdfAnalyzerUtils.tagged((Value)value).isIteratorTrueAssumption()) {
                    this.modifiedAsmAnalyzer.requestIFNELoopModification();
                }
                return super.unaryOperation(insn, value);
            }
            case 192: {
                return value;
            }
            case 179: {
                this.analyzer.handlePutStatic();
                return super.unaryOperation(insn, value);
            }
            case 180: {
                FieldInsnNode field = (FieldInsnNode)insn;
                if (!UdfAnalyzerUtils.isTagged((Value)value)) {
                    return super.unaryOperation(insn, value);
                }
                TaggedValue taggedValue = (TaggedValue)value;
                if (taggedValue.isInput()) {
                    return super.unaryOperation(insn, value);
                }
                if (taggedValue.canContainFields() && taggedValue.containerContains(field.name)) {
                    TaggedValue tv = taggedValue.getContainerMapping().get(field.name);
                    if (tv != null) {
                        return tv;
                    }
                } else {
                    if (taggedValue.isThis() && !taggedValue.containerContains(field.name)) {
                        TaggedValue tv = new TaggedValue(Type.getType((String)field.desc));
                        taggedValue.addContainerMapping(field.name, tv, this.currentFrame);
                        return tv;
                    }
                    if (taggedValue.isRegular()) {
                        taggedValue.setTag(TaggedValue.Tag.CONTAINER);
                        TaggedValue tv = new TaggedValue(Type.getType((String)field.desc));
                        taggedValue.addContainerMapping(field.name, tv, this.currentFrame);
                        return tv;
                    }
                }
                return super.unaryOperation(insn, value);
            }
            case 132: {
                if (UdfAnalyzerUtils.isTagged((Value)value) && (UdfAnalyzerUtils.tagged((Value)value).isIntConstant() || UdfAnalyzerUtils.tagged((Value)value).isInput())) {
                    UdfAnalyzerUtils.tagged((Value)value).makeRegular();
                }
                return super.unaryOperation(insn, value);
            }
        }
        return super.unaryOperation(insn, value);
    }

    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        if (UdfAnalyzerUtils.isTagged((Value)value1) && UdfAnalyzerUtils.tagged((Value)value1).isInput()) {
            UdfAnalyzerUtils.tagged((Value)value1).makeRegular();
        }
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 181: {
                if (!UdfAnalyzerUtils.isTagged((Value)value1)) {
                    return null;
                }
                TaggedValue taggedValue = (TaggedValue)value1;
                FieldInsnNode field = (FieldInsnNode)insn;
                boolean value2HasInputDependency = UdfAnalyzerUtils.hasImportantDependencies(value2);
                if (!taggedValue.isInput() && value2HasInputDependency) {
                    if (!taggedValue.canContainFields()) {
                        taggedValue.setTag(TaggedValue.Tag.CONTAINER);
                    }
                    taggedValue.addContainerMapping(field.name, UdfAnalyzerUtils.tagged((Value)value2), this.currentFrame);
                } else if (!taggedValue.isInput() && !value2HasInputDependency) {
                    if (!taggedValue.canContainFields()) {
                        taggedValue.setTag(TaggedValue.Tag.CONTAINER);
                    }
                    taggedValue.addContainerMapping(field.name, null, this.currentFrame);
                } else if (taggedValue.isInput()) {
                    taggedValue.makeRegular();
                }
                return null;
            }
        }
        return super.binaryOperation(insn, value1, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BasicValue naryOperation(AbstractInsnNode insn, List rawValues) throws AnalyzerException {
        List values = rawValues;
        switch (insn.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                boolean isStatic = insn.getOpcode() == 184;
                MethodInsnNode method = (MethodInsnNode)insn;
                String methodOwner = method.owner;
                if (method.name.equals("getField") || method.name.equals("setField")) {
                    try {
                        String newMethodOwner = (String)UdfAnalyzerUtils.findMethodNode(methodOwner, method.name, method.desc)[1];
                        if (newMethodOwner.startsWith("org/apache/flink/api/java/tuple/Tuple")) {
                            methodOwner = newMethodOwner;
                        }
                    }
                    catch (IllegalStateException newMethodOwner) {
                        // empty catch block
                    }
                }
                if (method.name.equals("collect") && methodOwner.equals("org/apache/flink/util/Collector") && UdfAnalyzerUtils.isTagged((Value)values.get(0)) && UdfAnalyzerUtils.tagged((Value)values.get(0)).isCollector()) {
                    if (UdfAnalyzerUtils.isTagged((Value)values.get(1)) && UdfAnalyzerUtils.tagged((Value)values.get(1)).isNull()) {
                        this.analyzer.handleNullReturn();
                        return super.naryOperation(insn, values);
                    } else if (UdfAnalyzerUtils.hasImportantDependencies((BasicValue)values.get(1))) {
                        this.analyzer.getCollectorValues().add(UdfAnalyzerUtils.tagged((Value)values.get(1)));
                        this.analyzer.getCollectorValues().add(UdfAnalyzerUtils.tagged((Value)values.get(1)).copy());
                        return super.naryOperation(insn, values);
                    } else {
                        this.analyzer.getCollectorValues().add(null);
                    }
                    return super.naryOperation(insn, values);
                } else {
                    Type newType;
                    if (method.name.equals("iterator") && methodOwner.equals("java/lang/Iterable") && UdfAnalyzerUtils.isTagged((Value)values.get(0)) && UdfAnalyzerUtils.tagged((Value)values.get(0)).isInputIterable()) {
                        return new TaggedValue(Type.getObjectType((String)"java/util/Iterator"), UdfAnalyzerUtils.tagged((Value)values.get(0)).isInput1Iterable() ? TaggedValue.Tag.INPUT_1_ITERATOR : TaggedValue.Tag.INPUT_2_ITERATOR);
                    }
                    if (method.name.equals("hasNext") && methodOwner.equals("java/util/Iterator") && UdfAnalyzerUtils.isTagged((Value)values.get(0)) && UdfAnalyzerUtils.tagged((Value)values.get(0)).isInputIterator() && !this.analyzer.isUdfBinary() && !this.analyzer.isIteratorTrueAssumptionApplied()) {
                        return new TaggedValue(Type.BOOLEAN_TYPE, TaggedValue.Tag.ITERATOR_TRUE_ASSUMPTION);
                    }
                    if (method.name.equals("next") && methodOwner.equals("java/util/Iterator") && UdfAnalyzerUtils.isTagged((Value)values.get(0)) && UdfAnalyzerUtils.tagged((Value)values.get(0)).isInputIterator()) {
                        this.analyzer.applyIteratorTrueAssumption();
                        if (!UdfAnalyzerUtils.tagged((Value)values.get(0)).isInput1Iterator()) return this.analyzer.getInput2AsTaggedValue();
                        return this.analyzer.getInput1AsTaggedValue();
                    }
                    if (!isStatic && UdfAnalyzerUtils.isTagged((Value)values.get(0)) && UdfAnalyzerUtils.tagged((Value)values.get(0)).isThis() && UdfAnalyzerUtils.hasImportantDependencies((BasicValue)values.get(0)) && !this.isGetRuntimeContext(method)) {
                        TaggedValue tv = this.invokeNestedMethod(values, method);
                        if (tv == null) return super.naryOperation(insn, values);
                        return tv;
                    }
                    if ((isStatic || !UdfAnalyzerUtils.isTagged((Value)values.get(0)) || !UdfAnalyzerUtils.tagged((Value)values.get(0)).isThis() || !UdfAnalyzerUtils.hasImportantDependencies(values, true)) && (isStatic || UdfAnalyzerUtils.isTagged((Value)values.get(0)) && UdfAnalyzerUtils.tagged((Value)values.get(0)).isThis() || !UdfAnalyzerUtils.hasImportantDependencies(values, false)) && (!isStatic || !UdfAnalyzerUtils.hasImportantDependencies(values, false))) return super.naryOperation(insn, values);
                    if (UdfAnalyzerUtils.isTagged((Value)values.get(0)) && UdfAnalyzerUtils.tagged((Value)values.get(0)).isInput() && (!isStatic && (newType = this.checkForUnboxing(method.name, methodOwner)) != null || isStatic && (newType = this.checkForBoxing(method.name, method.desc, methodOwner)) != null)) {
                        return UdfAnalyzerUtils.tagged((Value)values.get(0)).copy(newType);
                    }
                    if (method.name.equals("setField") && methodOwner.startsWith("org/apache/flink/api/java/tuple/Tuple") && UdfAnalyzerUtils.isTagged((Value)values.get(0))) {
                        TaggedValue tuple = UdfAnalyzerUtils.tagged((Value)values.get(0));
                        tuple.setTag(TaggedValue.Tag.CONTAINER);
                        if (!UdfAnalyzerUtils.isTagged((Value)values.get(2)) || !UdfAnalyzerUtils.tagged((Value)values.get(2)).isIntConstant()) {
                            tuple.makeRegular();
                            return super.naryOperation(insn, values);
                        } else {
                            int constant = UdfAnalyzerUtils.tagged((Value)values.get(2)).getIntConstant();
                            if (constant < 0 || Integer.parseInt(methodOwner.split("Tuple")[1]) <= constant) {
                                this.analyzer.handleInvalidTupleAccess();
                            }
                            if (UdfAnalyzerUtils.isTagged((Value)values.get(1))) {
                                tuple.addContainerMapping("f" + constant, UdfAnalyzerUtils.tagged((Value)values.get(1)), this.currentFrame);
                                return super.naryOperation(insn, values);
                            } else {
                                tuple.addContainerMapping("f" + constant, null, this.currentFrame);
                            }
                        }
                        return super.naryOperation(insn, values);
                    } else {
                        if (method.name.equals("getField") && methodOwner.startsWith("org/apache/flink/api/java/tuple/Tuple")) {
                            TaggedValue tuple = UdfAnalyzerUtils.tagged((Value)values.get(0));
                            if (UdfAnalyzerUtils.isTagged((Value)values.get(1)) && UdfAnalyzerUtils.tagged((Value)values.get(1)).isIntConstant()) {
                                TaggedValue tupleField;
                                int constant = UdfAnalyzerUtils.tagged((Value)values.get(1)).getIntConstant();
                                if (constant < 0 || Integer.valueOf(methodOwner.split("Tuple")[1]) <= constant) {
                                    this.analyzer.handleInvalidTupleAccess();
                                }
                                if (!tuple.containerContains("f" + constant) || (tupleField = tuple.getContainerMapping().get("f" + constant)) == null) return super.naryOperation(insn, values);
                                return tupleField;
                            }
                            tuple.makeRegular();
                            return new TaggedValue(Type.getObjectType((String)"java/lang/Object"));
                        }
                        TaggedValue tv = this.invokeNestedMethod(values, method);
                        if (tv == null) return super.naryOperation(insn, values);
                        return tv;
                    }
                }
            }
        }
        return super.naryOperation(insn, values);
    }

    public void returnOperation(AbstractInsnNode insn, BasicValue value, BasicValue expected) throws AnalyzerException {
        if (UdfAnalyzerUtils.isTagged((Value)value) && UdfAnalyzerUtils.tagged((Value)value).isNull() && this.topLevelMethod) {
            this.analyzer.handleNullReturn();
        } else if (UdfAnalyzerUtils.hasImportantDependencies(value)) {
            this.returnValues.add(UdfAnalyzerUtils.tagged((Value)value));
            this.returnValues.add(UdfAnalyzerUtils.tagged((Value)value).copy());
        } else {
            this.returnValues.add(null);
        }
    }

    public BasicValue merge(BasicValue v, BasicValue w) {
        if (!UdfAnalyzerUtils.isTagged((Value)v) && !w.equals((Object)v) || UdfAnalyzerUtils.isTagged((Value)v) && !v.equals((Object)w)) {
            if (UdfAnalyzerUtils.isTagged((Value)v) && !UdfAnalyzerUtils.isTagged((Value)w)) {
                return new TaggedValue(w.getType());
            }
            if ((!UdfAnalyzerUtils.isTagged((Value)v) || UdfAnalyzerUtils.tagged((Value)v).canNotContainInput()) && UdfAnalyzerUtils.isTagged((Value)w) && UdfAnalyzerUtils.tagged((Value)w).canContainInput()) {
                TaggedValue taggedW = UdfAnalyzerUtils.tagged((Value)w);
                if (UdfAnalyzerUtils.hasImportantDependencies(taggedW) && this.rightMergePriority) {
                    TaggedValue returnValue = UdfAnalyzerUtils.removeUngroupedInputs(taggedW.copy());
                    if (returnValue != null) {
                        return returnValue;
                    }
                    return new TaggedValue(v.getType());
                }
                return new TaggedValue(v.getType());
            }
            if (!UdfAnalyzerUtils.isTagged((Value)v) && UdfAnalyzerUtils.isTagged((Value)w) && UdfAnalyzerUtils.tagged((Value)w).canNotContainInput()) {
                return v;
            }
            if (UdfAnalyzerUtils.isTagged((Value)v) && UdfAnalyzerUtils.isTagged((Value)w) && UdfAnalyzerUtils.tagged((Value)v).canContainInput()) {
                List<TaggedValue> list = Arrays.asList(UdfAnalyzerUtils.tagged((Value)v), UdfAnalyzerUtils.tagged((Value)w));
                TaggedValue returnValue = UdfAnalyzerUtils.mergeReturnValues(list);
                if (returnValue != null) {
                    return returnValue;
                }
            } else if (UdfAnalyzerUtils.isTagged((Value)v) && UdfAnalyzerUtils.tagged((Value)v).canNotContainInput()) {
                return v;
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return v;
    }
}

