/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.summarize.aggregation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.summarize.NumericColumnSummary;
import org.apache.flink.api.java.summarize.aggregation.Aggregator;
import org.apache.flink.api.java.summarize.aggregation.CompensatedSum;

@Internal
public abstract class NumericSummaryAggregator<T extends Number>
implements Aggregator<T, NumericColumnSummary<T>> {
    private static final long serialVersionUID = 1L;
    private long nonMissingCount = 0L;
    private long nullCount = 0L;
    private long nanCount = 0L;
    private long infinityCount = 0L;
    private Aggregator<T, T> min = this.initMin();
    private Aggregator<T, T> max = this.initMax();
    private Aggregator<T, T> sum = this.initSum();
    private CompensatedSum mean = CompensatedSum.ZERO;
    private CompensatedSum m2 = CompensatedSum.ZERO;

    @Override
    public void aggregate(T value) {
        if (value == null) {
            ++this.nullCount;
        } else if (this.isNan(value)) {
            ++this.nanCount;
        } else if (this.isInfinite(value)) {
            ++this.infinityCount;
        } else {
            ++this.nonMissingCount;
            this.min.aggregate(value);
            this.max.aggregate(value);
            this.sum.aggregate(value);
            double doubleValue = ((Number)value).doubleValue();
            double delta = doubleValue - this.mean.value();
            this.mean = this.mean.add(delta / (double)this.nonMissingCount);
            this.m2 = this.m2.add(delta * (doubleValue - this.mean.value()));
        }
    }

    @Override
    public void combine(Aggregator<T, NumericColumnSummary<T>> otherSameType) {
        NumericSummaryAggregator other = (NumericSummaryAggregator)otherSameType;
        this.nullCount += other.nullCount;
        this.nanCount += other.nanCount;
        this.infinityCount += other.infinityCount;
        if (this.nonMissingCount == 0L) {
            this.nonMissingCount = other.nonMissingCount;
            this.min = other.min;
            this.max = other.max;
            this.sum = other.sum;
            this.mean = other.mean;
            this.m2 = other.m2;
        } else if (other.nonMissingCount != 0L) {
            long combinedCount = this.nonMissingCount + other.nonMissingCount;
            this.min.combine(other.min);
            this.max.combine(other.max);
            this.sum.combine(other.sum);
            double deltaMean = other.mean.value() - this.mean.value();
            this.mean = this.mean.add(deltaMean * (double)other.nonMissingCount / (double)combinedCount);
            this.m2 = this.m2.add(other.m2).add(deltaMean * deltaMean * (double)this.nonMissingCount * (double)other.nonMissingCount / (double)combinedCount);
            this.nonMissingCount = combinedCount;
        }
    }

    @Override
    public NumericColumnSummary<T> result() {
        Double variance = null;
        if (this.nonMissingCount > 1L) {
            variance = this.m2.value() / (double)(this.nonMissingCount - 1L);
        }
        return new NumericColumnSummary<Number>(this.nonMissingCount, this.nullCount, this.nanCount, this.infinityCount, this.nonMissingCount == 0L ? (Number)null : (Number)((Number)this.min.result()), this.nonMissingCount == 0L ? (Number)null : (Number)((Number)this.max.result()), this.nonMissingCount == 0L ? (Number)null : (Number)((Number)this.sum.result()), this.nonMissingCount == 0L ? null : Double.valueOf(this.mean.value()), variance, variance == null ? null : Double.valueOf(Math.sqrt(variance)));
    }

    protected abstract Aggregator<T, T> initMin();

    protected abstract Aggregator<T, T> initMax();

    protected abstract Aggregator<T, T> initSum();

    protected abstract boolean isNan(T var1);

    protected abstract boolean isInfinite(T var1);
}

