/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class RemoteEnvironmentConfigUtils {
    public static void validate(String host, int port) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The RemoteEnvironment cannot be instantiated when running in a pre-defined context (such as Command Line Client, Scala Shell, or TestEnvironment)");
        }
        Preconditions.checkNotNull((Object)host);
        Preconditions.checkArgument((port > 0 && port < 65535 ? 1 : 0) != 0);
    }

    public static void setJobManagerAddressToConfig(String host, int port, Configuration configuration) {
        InetSocketAddress address = new InetSocketAddress(host, port);
        configuration.setString(JobManagerOptions.ADDRESS, address.getHostString());
        configuration.setInteger(JobManagerOptions.PORT, address.getPort());
        configuration.setString(RestOptions.ADDRESS, address.getHostString());
        configuration.setInteger(RestOptions.PORT, address.getPort());
    }

    public static void setJarURLsToConfig(String[] jars, Configuration configuration) {
        List<URL> jarURLs = RemoteEnvironmentConfigUtils.getJarFiles(jars);
        ConfigUtils.encodeCollectionToConfig((WritableConfig)configuration, (ConfigOption)PipelineOptions.JARS, jarURLs, URL::toString);
    }

    private static List<URL> getJarFiles(String[] jars) {
        return jars == null ? Collections.emptyList() : Arrays.stream(jars).map(jarPath -> {
            try {
                URL fileURL = new File((String)jarPath).getAbsoluteFile().toURI().toURL();
                JarUtils.checkJarFile((URL)fileURL);
                return fileURL;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("JAR file path invalid", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem with jar file " + jarPath, e);
            }
        }).collect(Collectors.toList());
    }
}

