/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.MapOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;

@Internal
public class PlanProjectOperator<T, R extends Tuple>
extends MapOperatorBase<T, R, MapFunction<T, R>> {
    public PlanProjectOperator(int[] fields, String name, TypeInformation<T> inType, TypeInformation<R> outType, ExecutionConfig executionConfig) {
        super(PlanProjectOperator.createTypedProjector(fields), new UnaryOperatorInformation(inType, outType), name);
    }

    private static <T, R extends Tuple, X extends Tuple> MapFunction<T, R> createTypedProjector(int[] fields) {
        return new MapProjector(fields);
    }

    public static final class MapProjector<T extends Tuple, R extends Tuple>
    extends AbstractRichFunction
    implements MapFunction<T, R> {
        private static final long serialVersionUID = 1L;
        private final int[] fields;
        private final Tuple outTuple;

        private MapProjector(int[] fields) {
            this.fields = fields;
            try {
                this.outTuple = (Tuple)Tuple.getTupleClass((int)fields.length).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public R map(Tuple inTuple) throws Exception {
            for (int i = 0; i < this.fields.length; ++i) {
                this.outTuple.setField(inTuple.getField(this.fields[i]), i);
            }
            return (R)this.outTuple;
        }
    }
}

