/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.SampleInCoordinator;
import org.apache.flink.api.java.functions.SampleInPartition;
import org.apache.flink.api.java.functions.SampleWithFraction;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.MapPartitionOperator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Collector;

@PublicEvolving
public final class DataSetUtils {
    private static <T> DataSet<Tuple2<Integer, Long>> countElements(DataSet<T> input) {
        return input.mapPartition(new RichMapPartitionFunction<T, Tuple2<Integer, Long>>(){

            public void mapPartition(Iterable<T> values, Collector<Tuple2<Integer, Long>> out) throws Exception {
                long counter = 0L;
                for (Object value : values) {
                    ++counter;
                }
                out.collect((Object)new Tuple2((Object)this.getRuntimeContext().getIndexOfThisSubtask(), (Object)counter));
            }
        });
    }

    public static <T> DataSet<Tuple2<Long, T>> zipWithIndex(DataSet<T> input) {
        DataSet<Tuple2<Integer, Long>> elementCount = DataSetUtils.countElements(input);
        return input.mapPartition(new RichMapPartitionFunction<T, Tuple2<Long, T>>(){
            long start = 0L;

            public void open(Configuration parameters) throws Exception {
                super.open(parameters);
                List offsets = (List)this.getRuntimeContext().getBroadcastVariableWithInitializer("counts", (BroadcastVariableInitializer)new BroadcastVariableInitializer<Tuple2<Integer, Long>, List<Tuple2<Integer, Long>>>(){

                    public List<Tuple2<Integer, Long>> initializeBroadcastVariable(Iterable<Tuple2<Integer, Long>> data) {
                        ArrayList<Tuple2<Integer, Long>> sortedData = Lists.newArrayList(data);
                        Collections.sort(sortedData, new Comparator<Tuple2<Integer, Long>>(){

                            @Override
                            public int compare(Tuple2<Integer, Long> o1, Tuple2<Integer, Long> o2) {
                                return ((Integer)o1.f0).compareTo((Integer)o2.f0);
                            }
                        });
                        return sortedData;
                    }
                });
                for (int i = 0; i < this.getRuntimeContext().getIndexOfThisSubtask(); ++i) {
                    this.start += ((Long)((Tuple2)offsets.get((int)i)).f1).longValue();
                }
            }

            public void mapPartition(Iterable<T> values, Collector<Tuple2<Long, T>> out) throws Exception {
                for (Object value : values) {
                    out.collect((Object)new Tuple2((Object)this.start++, value));
                }
            }
        }).withBroadcastSet((DataSet)elementCount, "counts");
    }

    public static <T> DataSet<Tuple2<Long, T>> zipWithUniqueId(DataSet<T> input) {
        return input.mapPartition(new RichMapPartitionFunction<T, Tuple2<Long, T>>(){
            long maxBitSize = DataSetUtils.getBitSize(Long.MAX_VALUE);
            long shifter = 0L;
            long start = 0L;
            long taskId = 0L;
            long label = 0L;

            public void open(Configuration parameters) throws Exception {
                super.open(parameters);
                this.shifter = DataSetUtils.getBitSize(this.getRuntimeContext().getNumberOfParallelSubtasks() - 1);
                this.taskId = this.getRuntimeContext().getIndexOfThisSubtask();
            }

            public void mapPartition(Iterable<T> values, Collector<Tuple2<Long, T>> out) throws Exception {
                for (Object value : values) {
                    this.label = (this.start << (int)this.shifter) + this.taskId;
                    if ((long)DataSetUtils.getBitSize(this.start) + this.shifter < this.maxBitSize) {
                        out.collect((Object)new Tuple2((Object)this.label, value));
                        ++this.start;
                        continue;
                    }
                    throw new Exception("Exceeded Long value range while generating labels");
                }
            }
        });
    }

    public static <T> MapPartitionOperator<T, T> sample(DataSet<T> input, boolean withReplacement, double fraction) {
        return DataSetUtils.sample(input, withReplacement, fraction, Utils.RNG.nextLong());
    }

    public static <T> MapPartitionOperator<T, T> sample(DataSet<T> input, boolean withReplacement, double fraction, long seed) {
        return input.mapPartition(new SampleWithFraction(withReplacement, fraction, seed));
    }

    public static <T> DataSet<T> sampleWithSize(DataSet<T> input, boolean withReplacement, int numSamples) {
        return DataSetUtils.sampleWithSize(input, withReplacement, numSamples, Utils.RNG.nextLong());
    }

    public static <T> DataSet<T> sampleWithSize(DataSet<T> input, boolean withReplacement, int numSamples, long seed) {
        SampleInPartition sampleInPartition = new SampleInPartition(withReplacement, numSamples, seed);
        MapPartitionOperator mapPartitionOperator = input.mapPartition(sampleInPartition);
        String callLocation = Utils.getCallLocationName();
        SampleInCoordinator sampleInCoordinator = new SampleInCoordinator(withReplacement, numSamples, seed);
        return new GroupReduceOperator(mapPartitionOperator, input.getType(), sampleInCoordinator, callLocation);
    }

    public static <T> Utils.ChecksumHashCode checksumHashCode(DataSet<T> input) throws Exception {
        String id = new AbstractID().toString();
        input.output(new Utils.ChecksumHashCodeHelper(id)).name("ChecksumHashCode");
        JobExecutionResult res = input.getExecutionEnvironment().execute();
        return (Utils.ChecksumHashCode)res.getAccumulatorResult(id);
    }

    public static int getBitSize(long value) {
        if (value > Integer.MAX_VALUE) {
            return 64 - Integer.numberOfLeadingZeros((int)(value >> 32));
        }
        return 32 - Integer.numberOfLeadingZeros((int)value);
    }

    private DataSetUtils() {
        throw new RuntimeException();
    }
}

