/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.shaded.com.google.common.base.Joiner;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.primitives.Ints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Keys<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Keys.class);

    public abstract int getNumberOfKeyFields();

    public boolean isEmpty() {
        return this.getNumberOfKeyFields() == 0;
    }

    public abstract boolean areCompatible(Keys<?> var1) throws IncompatibleKeysException;

    public abstract int[] computeLogicalKeyPositions();

    public abstract <E> void validateCustomPartitioner(Partitioner<E> var1, TypeInformation<E> var2);

    private static String[] removeDuplicates(String[] in) {
        LinkedList<String> ret = new LinkedList<String>();
        for (String el : in) {
            if (ret.contains(el)) continue;
            ret.add(el);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static final int[] rangeCheckFields(int[] fields, int maxAllowedField) {
        int k = 0;
        int last = fields[0];
        if (last < 0 || last > maxAllowedField) {
            throw new IllegalArgumentException("Tuple position is out of range: " + last);
        }
        for (int i = 1; i < fields.length; ++i) {
            if (fields[i] < 0 || fields[i] > maxAllowedField) {
                throw new IllegalArgumentException("Tuple position is out of range.");
            }
            if (fields[i] == last) continue;
            last = fields[i];
            fields[++k] = fields[i];
        }
        if (k == fields.length - 1) {
            return fields;
        }
        return Arrays.copyOfRange(fields, 0, k + 1);
    }

    public static class IncompatibleKeysException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public static final String SIZE_MISMATCH_MESSAGE = "The number of specified keys is different.";

        public IncompatibleKeysException(String message) {
            super(message);
        }

        public IncompatibleKeysException(TypeInformation<?> typeInformation, TypeInformation<?> typeInformation2) {
            super(typeInformation + " and " + typeInformation2 + " are not compatible");
        }
    }

    public static class ExpressionKeys<T>
    extends Keys<T> {
        public static final String SELECT_ALL_CHAR = "*";
        public static final String SELECT_ALL_CHAR_SCALA = "_";
        private List<CompositeType.FlatFieldDescriptor> keyFields;

        public ExpressionKeys(int[] groupingFields, TypeInformation<T> type) {
            this(groupingFields, type, false);
        }

        public ExpressionKeys(int[] groupingFields, TypeInformation<T> type, boolean allowEmpty) {
            if (!type.isTupleType()) {
                throw new InvalidProgramException("Specifying keys via field positions is only valid for tuple data types. Type: " + type);
            }
            if (!(allowEmpty || groupingFields != null && groupingFields.length != 0)) {
                throw new IllegalArgumentException("The grouping fields must not be empty.");
            }
            if (groupingFields == null || groupingFields.length == 0) {
                groupingFields = new int[type.getArity()];
                for (int i = 0; i < groupingFields.length; ++i) {
                    groupingFields[i] = i;
                }
            } else {
                groupingFields = Keys.rangeCheckFields(groupingFields, type.getArity() - 1);
            }
            Preconditions.checkArgument(groupingFields.length > 0, "Grouping fields can not be empty at this point");
            this.keyFields = new ArrayList<CompositeType.FlatFieldDescriptor>(type.getTotalFields());
            block1: for (int j = 0; j < groupingFields.length; ++j) {
                int keyPos = groupingFields[j];
                int offset = 0;
                for (int i = 0; i < type.getArity(); ++i) {
                    TypeInformation fieldType = ((CompositeType)type).getTypeAt(i);
                    if (i < keyPos) {
                        offset += fieldType.getTotalFields();
                        continue;
                    }
                    if (fieldType instanceof CompositeType) {
                        ((CompositeType)fieldType).getFlatFields(SELECT_ALL_CHAR, offset, this.keyFields);
                        continue block1;
                    }
                    if (fieldType instanceof AtomicType) {
                        this.keyFields.add(new CompositeType.FlatFieldDescriptor(offset, fieldType));
                        continue block1;
                    }
                    throw new InvalidProgramException("Field type is neither CompositeType nor AtomicType: " + fieldType);
                }
            }
            this.keyFields = ExpressionKeys.removeNullElementsFromList(this.keyFields);
        }

        public static <R> List<R> removeNullElementsFromList(List<R> in) {
            ArrayList<R> elements = new ArrayList<R>();
            for (R e : in) {
                if (e == null) continue;
                elements.add(e);
            }
            return elements;
        }

        public ExpressionKeys(String[] expressionsIn, TypeInformation<T> type) {
            Preconditions.checkNotNull(expressionsIn, "Field expression cannot be null.");
            if (type instanceof AtomicType) {
                if (!type.isKeyType()) {
                    throw new InvalidProgramException("This type (" + type + ") cannot be used as key.");
                }
                if (expressionsIn.length != 1 || !SELECT_ALL_CHAR.equals(expressionsIn[0]) && !SELECT_ALL_CHAR_SCALA.equals(expressionsIn[0])) {
                    throw new InvalidProgramException("Field expression for atomic type must be equal to '*' or '_'.");
                }
                this.keyFields = new ArrayList<CompositeType.FlatFieldDescriptor>(1);
                this.keyFields.add(new CompositeType.FlatFieldDescriptor(0, type));
            } else {
                CompositeType cType = (CompositeType)type;
                String[] expressions = Keys.removeDuplicates(expressionsIn);
                if (expressionsIn.length != expressions.length) {
                    LOG.warn("The key expressions contained duplicates. They are now unique");
                }
                this.keyFields = new ArrayList<CompositeType.FlatFieldDescriptor>(expressions.length);
                for (int i = 0; i < expressions.length; ++i) {
                    List keys = cType.getFlatFields(expressions[i]);
                    if (keys.size() == 0) {
                        throw new InvalidProgramException("Unable to extract key from expression '" + expressions[i] + "' on key " + cType);
                    }
                    this.keyFields.addAll(keys);
                }
            }
        }

        @Override
        public int getNumberOfKeyFields() {
            if (this.keyFields == null) {
                return 0;
            }
            return this.keyFields.size();
        }

        @Override
        public boolean areCompatible(Keys<?> other) throws IncompatibleKeysException {
            if (other instanceof ExpressionKeys) {
                ExpressionKeys oKey = (ExpressionKeys)other;
                if (oKey.getNumberOfKeyFields() != this.getNumberOfKeyFields()) {
                    throw new IncompatibleKeysException("The number of specified keys is different.");
                }
                for (int i = 0; i < this.keyFields.size(); ++i) {
                    if (this.keyFields.get(i).getType().equals(oKey.keyFields.get(i).getType())) continue;
                    throw new IncompatibleKeysException(this.keyFields.get(i).getType(), oKey.keyFields.get(i).getType());
                }
                return true;
            }
            if (other instanceof SelectorFunctionKeys) {
                return other.areCompatible(this);
            }
            throw new IncompatibleKeysException("The key is not compatible with " + other);
        }

        @Override
        public int[] computeLogicalKeyPositions() {
            ArrayList<Integer> logicalKeys = new ArrayList<Integer>();
            for (CompositeType.FlatFieldDescriptor kd : this.keyFields) {
                logicalKeys.add(kd.getPosition());
            }
            return Ints.toArray(logicalKeys);
        }

        @Override
        public <E> void validateCustomPartitioner(Partitioner<E> partitioner, TypeInformation<E> typeInfo) {
            TypeInformation keyType;
            if (this.keyFields.size() != 1) {
                throw new InvalidProgramException("Custom partitioners can only be used with keys that have one key field.");
            }
            if (typeInfo == null) {
                try {
                    typeInfo = TypeExtractor.getPartitionerTypes(partitioner);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (typeInfo != null && !(typeInfo instanceof GenericTypeInfo) && !(keyType = this.keyFields.get(0).getType()).equals(typeInfo)) {
                throw new InvalidProgramException("The partitioner is incompatible with the key type. Partitioner type: " + typeInfo + " , key type: " + keyType);
            }
        }

        public String toString() {
            Joiner join = Joiner.on('.');
            return "ExpressionKeys: " + join.join(this.keyFields);
        }
    }

    public static class SelectorFunctionKeys<T, K>
    extends Keys<T> {
        private final KeySelector<T, K> keyExtractor;
        private final TypeInformation<K> keyType;
        private final int[] logicalKeyFields;

        public SelectorFunctionKeys(KeySelector<T, K> keyExtractor, TypeInformation<T> inputType, TypeInformation<K> keyType) {
            if (keyExtractor == null) {
                throw new NullPointerException("Key extractor must not be null.");
            }
            if (keyType == null) {
                throw new NullPointerException("Key type must not be null.");
            }
            this.keyExtractor = keyExtractor;
            this.keyType = keyType;
            if (!keyType.isKeyType()) {
                throw new InvalidProgramException("Return type " + keyType + " of KeySelector " + keyExtractor.getClass() + " is not a valid key type");
            }
            if (keyType instanceof CompositeType) {
                ExpressionKeys<K> ek = new ExpressionKeys<K>(new String[]{"*"}, keyType);
                this.logicalKeyFields = ek.computeLogicalKeyPositions();
            } else {
                this.logicalKeyFields = new int[]{0};
            }
        }

        public TypeInformation<K> getKeyType() {
            return this.keyType;
        }

        public KeySelector<T, K> getKeyExtractor() {
            return this.keyExtractor;
        }

        @Override
        public int getNumberOfKeyFields() {
            return this.logicalKeyFields.length;
        }

        @Override
        public boolean areCompatible(Keys<?> other) throws IncompatibleKeysException {
            if (other instanceof SelectorFunctionKeys) {
                SelectorFunctionKeys sfk = (SelectorFunctionKeys)other;
                return sfk.keyType.equals(this.keyType);
            }
            if (other instanceof ExpressionKeys) {
                ExpressionKeys expressionKeys = (ExpressionKeys)other;
                if (this.keyType.isTupleType()) {
                    TupleTypeInfoBase tupleKeyType = (TupleTypeInfoBase)this.keyType;
                    List keyTypeFields = tupleKeyType.getFlatFields("*");
                    if (expressionKeys.keyFields.size() != keyTypeFields.size()) {
                        throw new IncompatibleKeysException("The number of specified keys is different.");
                    }
                    for (int i = 0; i < expressionKeys.keyFields.size(); ++i) {
                        if (((CompositeType.FlatFieldDescriptor)expressionKeys.keyFields.get(i)).getType().equals(((CompositeType.FlatFieldDescriptor)keyTypeFields.get(i)).getType())) continue;
                        throw new IncompatibleKeysException(((CompositeType.FlatFieldDescriptor)expressionKeys.keyFields.get(i)).getType(), ((CompositeType.FlatFieldDescriptor)keyTypeFields.get(i)).getType());
                    }
                    return true;
                }
                if (expressionKeys.getNumberOfKeyFields() != 1) {
                    throw new IncompatibleKeysException("Key selector functions are only compatible to one key");
                }
                if (((CompositeType.FlatFieldDescriptor)expressionKeys.keyFields.get(0)).getType().equals(this.keyType)) {
                    return true;
                }
                throw new IncompatibleKeysException(((CompositeType.FlatFieldDescriptor)expressionKeys.keyFields.get(0)).getType(), this.keyType);
            }
            throw new IncompatibleKeysException("The key is not compatible with " + other);
        }

        @Override
        public int[] computeLogicalKeyPositions() {
            return this.logicalKeyFields;
        }

        @Override
        public <E> void validateCustomPartitioner(Partitioner<E> partitioner, TypeInformation<E> typeInfo) {
            if (this.logicalKeyFields.length != 1) {
                throw new InvalidProgramException("Custom partitioners can only be used with keys that have one key field.");
            }
            if (typeInfo == null) {
                try {
                    typeInfo = TypeExtractor.getPartitionerTypes(partitioner);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (typeInfo != null && !(typeInfo instanceof GenericTypeInfo) && !this.keyType.equals(typeInfo)) {
                throw new InvalidProgramException("The partitioner is imcompatible with the key type. Partitioner type: " + typeInfo + " , key type: " + this.keyType);
            }
        }

        public String toString() {
            return "Key function (Type: " + this.keyType + ")";
        }
    }
}

