/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.flink.api.common.io.GenericCsvInputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvInputFormat<OUT>
extends GenericCsvInputFormat<OUT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CsvInputFormat.class);
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final String DEFAULT_FIELD_DELIMITER = ",";
    private transient Object[] parsedValues;
    private Class<OUT> pojoTypeClass = null;
    private String[] pojoFieldsName = null;
    private transient Field[] pojoFields = null;
    private transient PojoTypeInfo<OUT> pojoTypeInfo = null;

    public CsvInputFormat(Path filePath, TypeInformation<OUT> typeInformation) {
        this(filePath, DEFAULT_LINE_DELIMITER, DEFAULT_FIELD_DELIMITER, typeInformation);
    }

    public CsvInputFormat(Path filePath, String lineDelimiter, String fieldDelimiter, TypeInformation<OUT> typeInformation) {
        super(filePath);
        Preconditions.checkArgument(typeInformation instanceof CompositeType);
        CompositeType compositeType = (CompositeType)typeInformation;
        this.setDelimiter(lineDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        Class[] classes = new Class[typeInformation.getArity()];
        int arity = typeInformation.getArity();
        for (int i = 0; i < arity; ++i) {
            classes[i] = compositeType.getTypeAt(i).getTypeClass();
        }
        this.setFieldTypes(classes);
        if (typeInformation instanceof PojoTypeInfo) {
            this.pojoTypeInfo = (PojoTypeInfo)typeInformation;
            this.pojoTypeClass = typeInformation.getTypeClass();
            this.pojoFieldsName = compositeType.getFieldNames();
            this.setOrderOfPOJOFields(this.pojoFieldsName);
        }
    }

    public void setOrderOfPOJOFields(String[] fieldsOrder) {
        Preconditions.checkNotNull(this.pojoTypeClass, "Field order can only be specified if output type is a POJO.");
        Preconditions.checkNotNull(fieldsOrder);
        int includedCount = 0;
        for (boolean isIncluded : this.fieldIncluded) {
            if (!isIncluded) continue;
            ++includedCount;
        }
        Preconditions.checkArgument(includedCount == fieldsOrder.length, includedCount + " CSV fields and " + fieldsOrder.length + " POJO fields selected. The number of selected CSV and POJO fields must be equal.");
        for (String field : fieldsOrder) {
            Preconditions.checkNotNull(field, "The field name cannot be null.");
            Preconditions.checkArgument(this.pojoTypeInfo.getFieldIndex(field) != -1, "Field \"" + field + "\" is not a member of POJO class " + this.pojoTypeClass.getName());
        }
        this.pojoFieldsName = Arrays.copyOfRange(fieldsOrder, 0, fieldsOrder.length);
    }

    public void setFieldTypes(Class<?> ... fieldTypes) {
        if (fieldTypes == null || fieldTypes.length == 0) {
            throw new IllegalArgumentException("Field types must not be null or empty.");
        }
        this.setFieldTypesGeneric(fieldTypes);
    }

    public void setFields(int[] sourceFieldIndices, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull(sourceFieldIndices);
        Preconditions.checkNotNull(fieldTypes);
        CsvInputFormat.checkForMonotonousOrder((int[])sourceFieldIndices, (Class[])fieldTypes);
        this.setFieldsGeneric(sourceFieldIndices, fieldTypes);
    }

    public void setFields(boolean[] sourceFieldMask, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull(sourceFieldMask);
        Preconditions.checkNotNull(fieldTypes);
        this.setFieldsGeneric(sourceFieldMask, fieldTypes);
    }

    public Class<?>[] getFieldTypes() {
        return super.getGenericFieldTypes();
    }

    public void open(FileInputSplit split) throws IOException {
        int i;
        super.open(split);
        FieldParser[] fieldParsers = this.getFieldParsers();
        if (fieldParsers.length == 0) {
            throw new IOException("CsvInputFormat.open(FileInputSplit split) - no field parsers to parse input");
        }
        this.parsedValues = new Object[fieldParsers.length];
        for (i = 0; i < fieldParsers.length; ++i) {
            this.parsedValues[i] = fieldParsers[i].createValue();
        }
        if (this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10) {
            this.lineDelimiterIsLinebreak = true;
        }
        if (this.pojoTypeClass != null) {
            this.pojoFields = new Field[this.pojoFieldsName.length];
            for (i = 0; i < this.pojoFieldsName.length; ++i) {
                try {
                    this.pojoFields[i] = this.pojoTypeClass.getDeclaredField(this.pojoFieldsName[i]);
                    this.pojoFields[i].setAccessible(true);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("There is no field called \"" + this.pojoFieldsName[i] + "\" in " + this.pojoTypeClass.getName(), e);
                }
            }
        }
        this.commentCount = 0;
        this.invalidLineCount = 0;
    }

    public OUT nextRecord(OUT record) throws IOException {
        Object returnRecord = null;
        while ((returnRecord = super.nextRecord(record)) == null && !this.reachedEnd()) {
        }
        return (OUT)returnRecord;
    }

    public OUT readRecord(OUT reuse, byte[] bytes, int offset, int numBytes) throws IOException {
        int i;
        if (this.lineDelimiterIsLinebreak && numBytes > 0 && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        if (this.commentPrefix != null && this.commentPrefix.length <= numBytes) {
            boolean isComment = true;
            for (i = 0; i < this.commentPrefix.length; ++i) {
                if (this.commentPrefix[i] == bytes[offset + i]) continue;
                isComment = false;
                break;
            }
            if (isComment) {
                ++this.commentCount;
                return null;
            }
        }
        if (this.parseRecord(this.parsedValues, bytes, offset, numBytes)) {
            if (this.pojoTypeClass == null) {
                Tuple result = (Tuple)reuse;
                for (i = 0; i < this.parsedValues.length; ++i) {
                    result.setField(this.parsedValues[i], i);
                }
            } else {
                for (int i2 = 0; i2 < this.parsedValues.length; ++i2) {
                    try {
                        this.pojoFields[i2].set(reuse, this.parsedValues[i2]);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Parsed value could not be set in POJO field \"" + this.pojoFieldsName[i2] + "\"", e);
                    }
                }
            }
            return reuse;
        }
        ++this.invalidLineCount;
        return null;
    }

    public String toString() {
        return "CSV Input (" + StringUtils.showControlCharacters((String)String.valueOf(this.getFieldDelimiter())) + ") " + this.getFilePath();
    }
}

