/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class ParameterTool
extends ExecutionConfig.GlobalJobParameters
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected static String NO_VALUE_KEY = "__NO_VALUE_KEY";
    protected static String DEFAULT_UNDEFINED = "<undefined>";
    protected final Map<String, String> data;
    protected final HashMap<String, String> defaultData;

    public static ParameterTool fromArgs(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>(args.length / 2);
        String key = null;
        String value = null;
        boolean expectValue = false;
        for (String arg : args) {
            if (arg.startsWith("--")) {
                if (expectValue) {
                    if (value != null) {
                        throw new IllegalStateException("Unexpected state");
                    }
                    map.put(key, NO_VALUE_KEY);
                }
                key = arg.substring(2);
                expectValue = true;
            } else if (arg.startsWith("-")) {
                if (expectValue) {
                    if (NumberUtils.isNumber((String)arg)) {
                        value = arg;
                        expectValue = false;
                    } else {
                        if (value != null) {
                            throw new IllegalStateException("Unexpected state");
                        }
                        map.put(key, NO_VALUE_KEY);
                        key = arg.substring(1);
                        expectValue = true;
                    }
                } else {
                    key = arg.substring(1);
                    expectValue = true;
                }
            } else if (expectValue) {
                value = arg;
                expectValue = false;
            } else {
                throw new RuntimeException("Error parsing arguments '" + Arrays.toString(args) + "' on '" + arg + "'. Unexpected value. Please prefix values with -- or -.");
            }
            if (value == null && key == null) {
                throw new IllegalStateException("Value and key can not be null at the same time");
            }
            if (key != null && value == null && !expectValue) {
                throw new IllegalStateException("Value expected but flag not set");
            }
            if (key != null && value != null) {
                map.put(key, value);
                key = null;
                value = null;
                expectValue = false;
            }
            if (key != null && key.length() == 0) {
                throw new IllegalArgumentException("The input " + Arrays.toString(args) + " contains an empty argument");
            }
            if (key == null || expectValue) continue;
            map.put(key, NO_VALUE_KEY);
            key = null;
            expectValue = false;
        }
        if (key != null) {
            map.put(key, NO_VALUE_KEY);
        }
        return ParameterTool.fromMap(map);
    }

    public static ParameterTool fromPropertiesFile(String path) throws IOException {
        File propertiesFile = new File(path);
        if (!propertiesFile.exists()) {
            throw new FileNotFoundException("Properties file " + path + " does not exist");
        }
        Properties props = new Properties();
        props.load(new FileInputStream(propertiesFile));
        return ParameterTool.fromMap(props);
    }

    public static ParameterTool fromMap(Map<String, String> map) {
        Preconditions.checkNotNull(map, "Unable to initialize from empty map");
        return new ParameterTool(map);
    }

    public static ParameterTool fromSystemProperties() {
        return ParameterTool.fromMap(System.getProperties());
    }

    private ParameterTool(Map<String, String> data) {
        this.data = new HashMap<String, String>(data);
        this.defaultData = new HashMap();
    }

    public int getNumberOfParameters() {
        return this.data.size();
    }

    public String get(String key) {
        this.addToDefaults(key, null);
        return this.data.get(key);
    }

    public String getRequired(String key) {
        this.addToDefaults(key, null);
        String value = this.get(key);
        if (value == null) {
            throw new RuntimeException("No data for required key '" + key + "'");
        }
        return value;
    }

    public String get(String key, String defaultValue) {
        this.addToDefaults(key, defaultValue);
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean has(String value) {
        this.addToDefaults(value, null);
        return this.data.containsKey(value);
    }

    public int getInt(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Integer.valueOf(value);
    }

    public int getLong(String key, int defaultValue) {
        this.addToDefaults(key, Integer.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public long getLong(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Long.valueOf(value);
    }

    public long getLong(String key, long defaultValue) {
        this.addToDefaults(key, Long.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Long.valueOf(value);
    }

    public float getFloat(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Float.valueOf(value).floatValue();
    }

    public float getFloat(String key, float defaultValue) {
        this.addToDefaults(key, Float.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Float.valueOf(value).floatValue();
    }

    public double getDouble(String key) {
        this.addToDefaults(key, null);
        String value = this.getRequired(key);
        return Double.valueOf(value);
    }

    public double getDouble(String key, double defaultValue) {
        this.addToDefaults(key, Double.toString(defaultValue));
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    protected void addToDefaults(String key, String value) {
        String currentValue = this.defaultData.get(key);
        if (currentValue == null) {
            if (value == null) {
                value = DEFAULT_UNDEFINED;
            }
            this.defaultData.put(key, value);
        } else if (currentValue.equals(DEFAULT_UNDEFINED) && value != null) {
            this.defaultData.put(key, value);
        }
    }

    public Configuration getConfiguration() {
        Configuration conf = new Configuration();
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            conf.setString(entry.getKey(), entry.getValue());
        }
        return conf;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll(this.data);
        return props;
    }

    public void createPropertiesFile(String pathToFile) throws IOException {
        this.createPropertiesFile(pathToFile, true);
    }

    public void createPropertiesFile(String pathToFile, boolean overwrite) throws IOException {
        File file = new File(pathToFile);
        if (file.exists()) {
            if (overwrite) {
                file.delete();
            } else {
                throw new RuntimeException("File " + pathToFile + " exists and overwriting is not allowed");
            }
        }
        Properties defaultProps = new Properties();
        defaultProps.putAll((Map<?, ?>)this.defaultData);
        defaultProps.store(new FileOutputStream(file), "Default file created by Flink's ParameterUtil.createPropertiesFile()");
    }

    protected Object clone() throws CloneNotSupportedException {
        return new ParameterTool(this.data);
    }

    public ParameterTool mergeWith(ParameterTool other) {
        ParameterTool ret = new ParameterTool(this.data);
        ret.data.putAll(other.data);
        return ret;
    }

    public Map<String, String> toMap() {
        return this.data;
    }
}

