/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputDecoder;
import org.apache.flink.api.java.typeutils.runtime.DataOutputEncoder;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;

public final class AvroSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private final Class<? extends T> typeToInstantiate;
    private transient ReflectDatumWriter<T> writer;
    private transient ReflectDatumReader<T> reader;
    private transient DataOutputEncoder encoder;
    private transient DataInputDecoder decoder;
    private transient Kryo kryo;
    private transient T deepCopyInstance;

    public AvroSerializer(Class<T> type) {
        this(type, type);
    }

    public AvroSerializer(Class<T> type, Class<? extends T> typeToInstantiate) {
        if (type == null || typeToInstantiate == null) {
            throw new NullPointerException();
        }
        InstantiationUtil.checkForInstantiation(typeToInstantiate);
        this.type = type;
        this.typeToInstantiate = typeToInstantiate;
    }

    public boolean isImmutableType() {
        return false;
    }

    public AvroSerializer<T> duplicate() {
        return new AvroSerializer<T>(this.type, this.typeToInstantiate);
    }

    public T createInstance() {
        return (T)InstantiationUtil.instantiate(this.typeToInstantiate);
    }

    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)this.kryo.copy(from);
    }

    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        try {
            return (T)this.kryo.copy(from);
        }
        catch (KryoException ke) {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)baout);
            this.kryo.writeObject(output, from);
            output.close();
            ByteArrayInputStream bain = new ByteArrayInputStream(baout.toByteArray());
            Input input = new Input((InputStream)bain);
            return (T)this.kryo.readObject(input, from.getClass());
        }
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        this.checkAvroInitialized();
        this.encoder.setOut((DataOutput)target);
        this.writer.write(value, (Encoder)this.encoder);
    }

    public T deserialize(DataInputView source) throws IOException {
        this.checkAvroInitialized();
        this.decoder.setIn((DataInput)source);
        return (T)this.reader.read(null, (Decoder)this.decoder);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        this.checkAvroInitialized();
        this.decoder.setIn((DataInput)source);
        return (T)this.reader.read(reuse, (Decoder)this.decoder);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.checkAvroInitialized();
        if (this.deepCopyInstance == null) {
            this.deepCopyInstance = InstantiationUtil.instantiate(this.type, Object.class);
        }
        this.decoder.setIn((DataInput)source);
        this.encoder.setOut((DataOutput)target);
        Object tmp = this.reader.read(this.deepCopyInstance, (Decoder)this.decoder);
        this.writer.write(tmp, (Encoder)this.encoder);
    }

    private void checkAvroInitialized() {
        if (this.reader == null) {
            this.reader = new ReflectDatumReader(this.type);
            this.writer = new ReflectDatumWriter(this.type);
            this.encoder = new DataOutputEncoder();
            this.decoder = new DataInputDecoder();
        }
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            this.kryo.register(GenericData.Array.class, (Serializer)new Serializers.SpecificInstanceCollectionSerializerForArrayList());
            this.kryo.register(Utf8.class);
            this.kryo.register(GenericData.EnumSymbol.class);
            this.kryo.register(GenericData.Fixed.class);
            this.kryo.register(GenericData.StringType.class);
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }

    public int hashCode() {
        return 1123788124 + this.type.hashCode() + this.typeToInstantiate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == AvroSerializer.class) {
            AvroSerializer other = (AvroSerializer)((Object)obj);
            return this.type == other.type && this.typeToInstantiate == other.typeToInstantiate;
        }
        return false;
    }
}

