/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.io.IOException;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.java.record.io.FileInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.types.Record;

public abstract class FixedLengthInputFormat
extends FileInputFormat {
    private static final long serialVersionUID = 1L;
    public static final String RECORDLENGTH_PARAMETER_KEY = "pact.fix-input.record-length";
    private static final int DEFAULT_READ_BUFFER_SIZE = 0x100000;
    private byte[] readBuffer;
    private long streamPos;
    private long streamEnd;
    private int readBufferPos;
    private int readBufferLimit;
    private int recordLength;
    private int readBufferSize = 0x100000;
    private boolean exhausted;

    protected FixedLengthInputFormat() {
    }

    public abstract boolean readBytes(Record var1, byte[] var2, int var3);

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getReadBufferSize() {
        return this.readBuffer.length;
    }

    public void configure(Configuration parameters) {
        super.configure(parameters);
        this.recordLength = parameters.getInteger(RECORDLENGTH_PARAMETER_KEY, 0);
        if (this.recordLength < 1) {
            throw new IllegalArgumentException("The record length parameter must be set and larger than 0.");
        }
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        int recordOffset = (int)(this.splitStart % (long)this.recordLength);
        if (recordOffset != 0) {
            this.stream.seek(this.splitStart + (long)recordOffset);
        }
        this.streamPos = this.splitStart + (long)recordOffset;
        this.streamEnd = this.splitStart + this.splitLength;
        this.streamEnd += this.streamEnd % (long)this.recordLength;
        this.readBufferSize += this.recordLength - this.readBufferSize % this.recordLength;
        if (this.readBuffer == null || this.readBuffer.length != this.readBufferSize) {
            this.readBuffer = new byte[this.readBufferSize];
        }
        this.readBufferLimit = 0;
        this.readBufferPos = 0;
        this.exhausted = false;
        this.fillReadBuffer();
    }

    public FileInputFormat.FileBaseStatistics getStatistics(BaseStatistics cachedStats) throws IOException {
        FileInputFormat.FileBaseStatistics stats = super.getStatistics(cachedStats);
        return stats == null ? null : new FileInputFormat.FileBaseStatistics(stats.getLastModificationTime(), stats.getTotalInputSize(), (float)this.recordLength);
    }

    public boolean reachedEnd() {
        return this.exhausted;
    }

    public Record nextRecord(Record reuse) throws IOException {
        if (this.readBufferLimit - this.readBufferPos <= 0) {
            this.fillReadBuffer();
            if (this.exhausted) {
                return null;
            }
        } else if (this.readBufferLimit - this.readBufferPos < this.recordLength) {
            throw new IOException("Unable to read full record");
        }
        boolean val = this.readBytes(reuse, this.readBuffer, this.readBufferPos);
        this.readBufferPos += this.recordLength;
        if (this.readBufferPos >= this.readBufferLimit) {
            this.fillReadBuffer();
        }
        return val ? reuse : null;
    }

    private void fillReadBuffer() throws IOException {
        if (this.splitLength == -1L) {
            int read = this.stream.read(this.readBuffer, 0, this.readBufferSize);
            if (read == -1) {
                this.exhausted = true;
            } else {
                this.streamPos += (long)read;
                this.readBufferPos = 0;
                this.readBufferLimit = read;
            }
            return;
        }
        int toRead = (int)Math.min(this.streamEnd - this.streamPos, (long)this.readBufferSize);
        if (toRead <= 0) {
            this.exhausted = true;
            return;
        }
        int read = this.stream.read(this.readBuffer, 0, toRead);
        if (read <= 0) {
            this.exhausted = true;
        } else {
            this.streamPos += (long)read;
            this.readBufferPos = 0;
            this.readBufferLimit = read;
        }
    }
}

