/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred.wrapper;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public class HadoopInputSplit
extends LocatableInputSplit {
    private static final long serialVersionUID = 1L;
    private transient InputSplit hadoopInputSplit;
    private JobConf jobConf;
    private int splitNumber;
    private String hadoopInputSplitTypeName;

    public InputSplit getHadoopInputSplit() {
        return this.hadoopInputSplit;
    }

    public HadoopInputSplit() {
    }

    public HadoopInputSplit(int splitNumber, InputSplit hInputSplit, JobConf jobconf) {
        this.splitNumber = splitNumber;
        this.hadoopInputSplit = hInputSplit;
        this.hadoopInputSplitTypeName = hInputSplit.getClass().getName();
        this.jobConf = jobconf;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.splitNumber);
        out.writeUTF(this.hadoopInputSplitTypeName);
        this.jobConf.write((DataOutput)out);
        this.hadoopInputSplit.write((DataOutput)out);
    }

    public void read(DataInputView in) throws IOException {
        this.splitNumber = in.readInt();
        this.hadoopInputSplitTypeName = in.readUTF();
        if (this.hadoopInputSplit == null) {
            try {
                Class<Writable> inputSplit = Class.forName(this.hadoopInputSplitTypeName).asSubclass(Writable.class);
                this.hadoopInputSplit = (InputSplit)WritableFactories.newInstance(inputSplit);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create InputSplit", e);
            }
        }
        this.jobConf = new JobConf();
        this.jobConf.readFields((DataInput)in);
        if (this.hadoopInputSplit instanceof Configurable) {
            ((Configurable)this.hadoopInputSplit).setConf((Configuration)this.jobConf);
        }
        this.hadoopInputSplit.readFields((DataInput)in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.splitNumber);
        out.writeUTF(this.hadoopInputSplitTypeName);
        this.jobConf.write((DataOutput)out);
        this.hadoopInputSplit.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.splitNumber = in.readInt();
        this.hadoopInputSplitTypeName = in.readUTF();
        if (this.hadoopInputSplit == null) {
            try {
                Class<Writable> inputSplit = Class.forName(this.hadoopInputSplitTypeName).asSubclass(Writable.class);
                this.hadoopInputSplit = (InputSplit)WritableFactories.newInstance(inputSplit);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create InputSplit", e);
            }
        }
        this.jobConf = new JobConf();
        this.jobConf.readFields((DataInput)in);
        if (this.hadoopInputSplit instanceof Configurable) {
            ((Configurable)this.hadoopInputSplit).setConf((Configuration)this.jobConf);
        }
        this.hadoopInputSplit.readFields((DataInput)in);
    }

    public int getSplitNumber() {
        return this.splitNumber;
    }

    public String[] getHostnames() {
        try {
            return this.hadoopInputSplit.getLocations();
        }
        catch (IOException ioe) {
            return new String[0];
        }
    }
}

