/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class WritableSerializer<T extends Writable>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> typeClass;
    private transient Kryo kryo;
    private transient T copyInstance;

    public WritableSerializer(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public T createInstance() {
        if (this.typeClass == NullWritable.class) {
            return (T)NullWritable.get();
        }
        return (T)((Writable)InstantiationUtil.instantiate(this.typeClass));
    }

    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)((Writable)this.kryo.copy(from));
    }

    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)((Writable)this.kryo.copy(from));
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        record.write((DataOutput)target);
    }

    public T deserialize(DataInputView source) throws IOException {
        return this.deserialize(this.createInstance(), source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.readFields((DataInput)source);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.ensureInstanceInstantiated();
        this.copyInstance.readFields((DataInput)source);
        this.copyInstance.write((DataOutput)target);
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return true;
    }

    private void ensureInstanceInstantiated() {
        if (this.copyInstance == null) {
            this.copyInstance = this.createInstance();
        }
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.typeClass);
        }
    }

    public int hashCode() {
        return this.typeClass.hashCode() + 177;
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == WritableSerializer.class) {
            WritableSerializer other = (WritableSerializer)((Object)obj);
            return this.typeClass == other.typeClass;
        }
        return false;
    }
}

