/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.configuration.Configuration;

public class DataSource<OUT>
extends Operator<OUT, DataSource<OUT>> {
    private final InputFormat<OUT, ?> inputFormat;
    private final String dataSourceLocationName;
    private Configuration parameters;

    public DataSource(ExecutionEnvironment context, InputFormat<OUT, ?> inputFormat, TypeInformation<OUT> type, String dataSourceLocationName) {
        super(context, type);
        this.dataSourceLocationName = dataSourceLocationName;
        if (inputFormat == null) {
            throw new IllegalArgumentException("The input format may not be null.");
        }
        this.inputFormat = inputFormat;
        if (inputFormat instanceof NonParallelInput) {
            this.dop = 1;
        }
    }

    public InputFormat<OUT, ?> getInputFormat() {
        return this.inputFormat;
    }

    public DataSource<OUT> withParameters(Configuration parameters) {
        this.parameters = parameters;
        return this;
    }

    public Configuration getParameters() {
        return this.parameters;
    }

    protected GenericDataSourceBase<OUT, ?> translateToDataFlow() {
        String name;
        String string = name = this.name != null ? this.name : "at " + this.dataSourceLocationName + " (" + this.inputFormat.getClass().getName() + ")";
        if (name.length() > 150) {
            name = name.substring(0, 150);
        }
        GenericDataSourceBase source = new GenericDataSourceBase(this.inputFormat, new OperatorInformation(this.getType()), name);
        source.setDegreeOfParallelism(this.dop);
        if (this.parameters != null) {
            source.getParameters().addAll(this.parameters);
        }
        return source;
    }
}

