/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.translation.JavaPlan;

public class RemoteEnvironment
extends ExecutionEnvironment {
    private final String host;
    private final int port;
    private final String[] jarFiles;

    public RemoteEnvironment(String host, int port, String ... jarFiles) {
        if (host == null) {
            throw new NullPointerException("Host must not be null.");
        }
        if (port < 1 || port >= 65535) {
            throw new IllegalArgumentException("Port out of range");
        }
        this.host = host;
        this.port = port;
        this.jarFiles = jarFiles;
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        JavaPlan p = this.createProgramPlan(jobName);
        PlanExecutor executor = PlanExecutor.createRemoteExecutor((String)this.host, (int)this.port, (String[])this.jarFiles);
        return executor.executePlan((Plan)p);
    }

    @Override
    public String getExecutionPlan() throws Exception {
        JavaPlan p = this.createProgramPlan("unnamed", false);
        p.setDefaultParallelism(this.getDegreeOfParallelism());
        this.registerCachedFilesWithPlan(p);
        PlanExecutor executor = PlanExecutor.createRemoteExecutor((String)this.host, (int)this.port, (String[])this.jarFiles);
        return executor.getOptimizerPlanAsJSON((Plan)p);
    }

    public String toString() {
        return "Remote Environment (" + this.host + ":" + this.port + " - DOP = " + (this.getDegreeOfParallelism() == -1 ? "default" : Integer.valueOf(this.getDegreeOfParallelism())) + ") : " + this.getIdString();
    }
}

