/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.api.java.typeutils.WritableTypeInfo;

public class TypeInfoParser {
    private static final String TUPLE_PACKAGE = "org.apache.flink.api.java.tuple";
    private static final String VALUE_PACKAGE = "org.apache.flink.types";
    private static final String WRITABLE_PACKAGE = "org.apache.hadoop.io";
    private static final Pattern tuplePattern = Pattern.compile("^((" + "org.apache.flink.api.java.tuple".replaceAll("\\.", "\\\\.") + "\\.)?Tuple[0-9]+)<");
    private static final Pattern writablePattern = Pattern.compile("^((" + "org.apache.hadoop.io".replaceAll("\\.", "\\\\.") + "\\.)?Writable)<([^\\s,>]*)(,|>|$)");
    private static final Pattern basicTypePattern = Pattern.compile("^((java\\.lang\\.)?(String|Integer|Byte|Short|Character|Double|Float|Long|Boolean))(,|>|$)");
    private static final Pattern basicType2Pattern = Pattern.compile("^(int|byte|short|char|double|float|long|boolean)(,|>|$)");
    private static final Pattern valueTypePattern = Pattern.compile("^((" + "org.apache.flink.types".replaceAll("\\.", "\\\\.") + "\\.)?(String|Int|Byte|Short|Char|Double|Float|Long|Boolean|List|Map|Null))Value(,|>|$)");
    private static final Pattern basicArrayTypePattern = Pattern.compile("^((java\\.lang\\.)?(String|Integer|Byte|Short|Character|Double|Float|Long|Boolean))\\[\\](,|>|$)");
    private static final Pattern basicArrayType2Pattern = Pattern.compile("^(int|byte|short|char|double|float|long|boolean)\\[\\](,|>|$)");
    private static final Pattern customObjectPattern = Pattern.compile("^([^\\s,>]+)(,|>|$)");

    public static <X> TypeInformation<X> parse(String infoString) {
        try {
            if (infoString == null) {
                throw new IllegalArgumentException("String is null.");
            }
            String clearedString = infoString.replaceAll("\\s", "");
            if (clearedString.length() == 0) {
                throw new IllegalArgumentException("String must not be empty.");
            }
            return TypeInfoParser.parse(new StringBuilder(clearedString));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("String could not be parsed: " + e.getMessage(), e);
        }
    }

    private static TypeInformation<?> parse(StringBuilder sb) throws ClassNotFoundException {
        String infoString = sb.toString();
        Matcher tupleMatcher = tuplePattern.matcher(infoString);
        Matcher writableMatcher = writablePattern.matcher(infoString);
        Matcher basicTypeMatcher = basicTypePattern.matcher(infoString);
        Matcher basicType2Matcher = basicType2Pattern.matcher(infoString);
        Matcher valueTypeMatcher = valueTypePattern.matcher(infoString);
        Matcher basicArrayTypeMatcher = basicArrayTypePattern.matcher(infoString);
        Matcher basicArrayType2Matcher = basicArrayType2Pattern.matcher(infoString);
        Matcher customObjectMatcher = customObjectPattern.matcher(infoString);
        if (infoString.length() == 0) {
            return null;
        }
        Object returnType = null;
        if (tupleMatcher.find()) {
            String className = tupleMatcher.group(1);
            sb.delete(0, className.length() + 1);
            int arity = Integer.parseInt(className.replaceAll("\\D", ""));
            Class<?> clazz = null;
            clazz = className.startsWith(TUPLE_PACKAGE) ? Class.forName(className) : Class.forName("org.apache.flink.api.java.tuple." + className);
            TypeInformation[] types = new TypeInformation[arity];
            for (int i = 0; i < arity; ++i) {
                types[i] = TypeInfoParser.parse(sb);
                if (types[i] != null) continue;
                throw new IllegalArgumentException("Tuple arity does not match given parameters.");
            }
            if (sb.charAt(0) != '>') {
                throw new IllegalArgumentException("Tuple arity does not match given parameters.");
            }
            sb.deleteCharAt(0);
            if (sb.length() > 0) {
                if (sb.length() >= 2 && sb.charAt(0) == '[' && sb.charAt(1) == ']') {
                    Class<?> arrayClazz = null;
                    arrayClazz = className.startsWith(TUPLE_PACKAGE) ? Class.forName("[L" + className + ";") : Class.forName("[Lorg.apache.flink.api.java.tuple." + className + ";");
                    returnType = ObjectArrayTypeInfo.getInfoFor(arrayClazz, new TupleTypeInfo(clazz, types));
                } else if (sb.length() < 1 || sb.charAt(0) != '[') {
                    returnType = new TupleTypeInfo(clazz, types);
                }
            } else {
                returnType = new TupleTypeInfo(clazz, types);
            }
        } else {
            if (writableMatcher.find()) {
                String className = writableMatcher.group(1);
                String fullyQualifiedName = writableMatcher.group(3);
                sb.delete(0, className.length() + 1 + fullyQualifiedName.length());
                try {
                    Class<?> clazz = Class.forName(fullyQualifiedName);
                    returnType = WritableTypeInfo.getWritableTypeInfo(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Class '" + fullyQualifiedName + "' could not be found for use as writable type. Please note that inner classes must be declared static.");
                }
            }
            if (basicTypeMatcher.find()) {
                String className = basicTypeMatcher.group(1);
                sb.delete(0, className.length());
                Class<?> clazz = null;
                clazz = className.startsWith("java.lang") ? Class.forName(className) : Class.forName("java.lang." + className);
                returnType = BasicTypeInfo.getInfoFor(clazz);
            } else if (basicType2Matcher.find()) {
                String className = basicType2Matcher.group(1);
                sb.delete(0, className.length());
                Class clazz = null;
                if (className.equals("int")) {
                    clazz = Integer.class;
                } else if (className.equals("byte")) {
                    clazz = Byte.class;
                } else if (className.equals("short")) {
                    clazz = Short.class;
                } else if (className.equals("char")) {
                    clazz = Character.class;
                } else if (className.equals("double")) {
                    clazz = Double.class;
                } else if (className.equals("float")) {
                    clazz = Float.class;
                } else if (className.equals("long")) {
                    clazz = Long.class;
                } else if (className.equals("boolean")) {
                    clazz = Boolean.class;
                }
                returnType = BasicTypeInfo.getInfoFor(clazz);
            } else if (valueTypeMatcher.find()) {
                String className = valueTypeMatcher.group(1);
                sb.delete(0, className.length() + 5);
                Class<?> clazz = null;
                clazz = className.startsWith(VALUE_PACKAGE) ? Class.forName(className + "Value") : Class.forName("org.apache.flink.types." + className + "Value");
                returnType = ValueTypeInfo.getValueTypeInfo(clazz);
            } else if (basicArrayTypeMatcher.find()) {
                String className = basicArrayTypeMatcher.group(1);
                sb.delete(0, className.length() + 2);
                Class<?> clazz = null;
                clazz = className.startsWith("java.lang") ? Class.forName("[L" + className + ";") : Class.forName("[Ljava.lang." + className + ";");
                returnType = BasicArrayTypeInfo.getInfoFor(clazz);
            } else if (basicArrayType2Matcher.find()) {
                String className = basicArrayType2Matcher.group(1);
                sb.delete(0, className.length() + 2);
                Class clazz = null;
                if (className.equals("int")) {
                    clazz = int[].class;
                } else if (className.equals("byte")) {
                    clazz = byte[].class;
                } else if (className.equals("short")) {
                    clazz = short[].class;
                } else if (className.equals("char")) {
                    clazz = char[].class;
                } else if (className.equals("double")) {
                    clazz = double[].class;
                } else if (className.equals("float")) {
                    clazz = float[].class;
                } else if (className.equals("long")) {
                    clazz = long[].class;
                } else if (className.equals("boolean")) {
                    clazz = boolean[].class;
                }
                returnType = PrimitiveArrayTypeInfo.getInfoFor(clazz);
            } else if (customObjectMatcher.find()) {
                String fullyQualifiedName = customObjectMatcher.group(1);
                sb.delete(0, fullyQualifiedName.length());
                if (fullyQualifiedName.contains("<")) {
                    throw new IllegalArgumentException("Parameterized custom classes are not supported by parser.");
                }
                if (fullyQualifiedName.endsWith("[]")) {
                    fullyQualifiedName = fullyQualifiedName.substring(0, fullyQualifiedName.length() - 2);
                    try {
                        Class<?> clazz = Class.forName("[L" + fullyQualifiedName + ";");
                        returnType = ObjectArrayTypeInfo.getInfoFor(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Class '" + fullyQualifiedName + "' could not be found for use as object array. Please note that inner classes must be declared static.");
                    }
                }
                try {
                    Class<?> clazz = Class.forName(fullyQualifiedName);
                    returnType = new GenericTypeInfo(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Class '" + fullyQualifiedName + "' could not be found for use as custom object. Please note that inner classes must be declared static.");
                }
            }
        }
        if (returnType == null) {
            throw new IllegalArgumentException("Error at '" + infoString + "'");
        }
        if (sb.length() > 0 && sb.charAt(0) == ',') {
            sb.deleteCharAt(0);
        }
        return returnType;
    }
}

