/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.aggregation;

import org.apache.flink.api.java.aggregation.AggregationFunction;
import org.apache.flink.api.java.aggregation.AggregationFunctionFactory;
import org.apache.flink.api.java.aggregation.UnsupportedAggregationTypeException;

public class MinAggregationFunction<T extends Comparable<T>>
extends AggregationFunction<T> {
    private static final long serialVersionUID = 1L;
    private T value;

    @Override
    public void initializeAggregate() {
        this.value = null;
    }

    @Override
    public void aggregate(T val) {
        int cmp;
        this.value = this.value != null ? ((cmp = this.value.compareTo(val)) < 0 ? this.value : val) : val;
    }

    @Override
    public T getAggregate() {
        return this.value;
    }

    public String toString() {
        return "MIN";
    }

    public static final class MinAggregationFunctionFactory
    implements AggregationFunctionFactory {
        private static final long serialVersionUID = 1L;

        @Override
        public <T> AggregationFunction<T> createAggregationFunction(Class<T> type) {
            if (Comparable.class.isAssignableFrom(type)) {
                return new MinAggregationFunction();
            }
            throw new UnsupportedAggregationTypeException("The type " + type.getName() + " is not supported for minimum aggregation. " + "Minimum aggregatable types must implement the Comparable interface.");
        }
    }
}

