/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.NullKeyFieldException;
import org.apache.flink.util.InstantiationUtil;

public final class PojoComparator<T>
extends TypeComparator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Field[] keyFields;
    private final TypeComparator<Object>[] comparators;
    private final int[] normalizedKeyLengths;
    private final int numLeadingNormalizableKeys;
    private final int normalizableKeyPrefixLen;
    private final boolean invertNormKey;
    private TypeSerializer<T> serializer;
    private final Class<T> type;
    private static final int[] HASH_SALT = new int[]{73, 79, 97, 113, 131, 197, 199, 311, 337, 373, 719, 733, 919, 971, 991, 1193, 1931, 3119, 3779, 7793, 7937, 9311, 9377, 11939, 19391, 19937, 37199, 39119, 71993, 91193, 93719, 93911};

    public PojoComparator(Field[] keyFields, TypeComparator<?>[] comparators, TypeSerializer<T> serializer, Class<T> type) {
        TypeComparator<Object> k;
        this.keyFields = keyFields;
        this.comparators = comparators;
        this.type = type;
        this.serializer = serializer;
        this.normalizedKeyLengths = new int[keyFields.length];
        int nKeys = 0;
        int nKeyLen = 0;
        boolean inverted = false;
        for (int i = 0; i < this.comparators.length && (k = this.comparators[i]).supportsNormalizedKey(); ++i) {
            if (i == 0) {
                inverted = k.invertNormalizedKey();
            } else if (k.invertNormalizedKey() != inverted) break;
            ++nKeys;
            int len = k.getNormalizeKeyLen();
            if (len < 0) {
                throw new RuntimeException("Comparator " + k.getClass().getName() + " specifies an invalid length for the normalized key: " + len);
            }
            this.normalizedKeyLengths[i] = len;
            if ((nKeyLen += this.normalizedKeyLengths[i]) >= 0) continue;
            nKeyLen = Integer.MAX_VALUE;
            break;
        }
        this.numLeadingNormalizableKeys = nKeys;
        this.normalizableKeyPrefixLen = nKeyLen;
        this.invertNormKey = inverted;
    }

    private PojoComparator(PojoComparator<T> toClone) {
        this.keyFields = toClone.keyFields;
        this.comparators = new TypeComparator[toClone.comparators.length];
        for (int i = 0; i < toClone.comparators.length; ++i) {
            this.comparators[i] = toClone.comparators[i].duplicate();
        }
        this.normalizedKeyLengths = toClone.normalizedKeyLengths;
        this.numLeadingNormalizableKeys = toClone.numLeadingNormalizableKeys;
        this.normalizableKeyPrefixLen = toClone.normalizableKeyPrefixLen;
        this.invertNormKey = toClone.invertNormKey;
        this.type = toClone.type;
        try {
            this.serializer = (TypeSerializer)InstantiationUtil.deserializeObject((byte[])InstantiationUtil.serializeObject(toClone.serializer), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot copy serializer", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot copy serializer", e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeInt(this.keyFields.length);
        for (Field field : this.keyFields) {
            out.writeObject(field.getDeclaringClass());
            out.writeUTF(field.getName());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numKeyFields = in.readInt();
        this.keyFields = new Field[numKeyFields];
        for (int i = 0; i < numKeyFields; ++i) {
            String fieldName = in.readUTF();
            this.keyFields[i] = null;
            for (Class clazz = (Class)in.readObject(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    this.keyFields[i] = clazz.getDeclaredField(fieldName);
                    this.keyFields[i].setAccessible(true);
                    break;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            if (this.keyFields[i] != null) continue;
            throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup. (" + fieldName + ")");
        }
    }

    public Field[] getKeyFields() {
        return this.keyFields;
    }

    public TypeComparator<Object>[] getComparators() {
        return this.comparators;
    }

    public int hash(T value) {
        int i;
        try {
            int code = 0;
            for (i = 0; i < this.keyFields.length; ++i) {
                code ^= this.comparators[i].hash(this.keyFields[i].get(value));
                code *= HASH_SALT[i & 0x1F];
            }
            return code;
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i].toString());
        }
        catch (IllegalAccessException iaex) {
            throw new RuntimeException("This should not happen since we call setAccesssible(true) in PojoTypeInfo.");
        }
    }

    public void setReference(T toCompare) {
        int i;
        try {
            for (i = 0; i < this.keyFields.length; ++i) {
                this.comparators[i].setReference(this.keyFields[i].get(toCompare));
            }
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i].toString());
        }
        catch (IllegalAccessException iaex) {
            throw new RuntimeException("This should not happen since we call setAccesssible(true) in PojoTypeInfo.");
        }
    }

    public boolean equalToReference(T candidate) {
        int i;
        try {
            for (i = 0; i < this.keyFields.length; ++i) {
                if (this.comparators[i].equalToReference(this.keyFields[i].get(candidate))) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i].toString());
        }
        catch (IllegalAccessException iaex) {
            throw new RuntimeException("This should not happen since we call setAccesssible(true) in PojoTypeInfo.");
        }
    }

    public int compareToReference(TypeComparator<T> referencedComparator) {
        int i;
        PojoComparator other = (PojoComparator)referencedComparator;
        try {
            for (i = 0; i < this.keyFields.length; ++i) {
                int cmp = this.comparators[i].compareToReference(other.comparators[i]);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i].toString());
        }
    }

    public int compare(T first, T second) {
        int i;
        try {
            for (i = 0; i < this.keyFields.length; ++i) {
                int cmp = this.comparators[i].compare(this.keyFields[i].get(first), this.keyFields[i].get(second));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i].toString() + " " + first.toString() + " " + second.toString());
        }
        catch (IllegalAccessException iaex) {
            throw new RuntimeException("This should not happen since we call setAccesssible(true) in PojoTypeInfo.");
        }
    }

    public int compare(DataInputView firstSource, DataInputView secondSource) throws IOException {
        Object first = this.serializer.createInstance();
        Object second = this.serializer.createInstance();
        first = this.serializer.deserialize(first, firstSource);
        second = this.serializer.deserialize(second, secondSource);
        return this.compare(first, second);
    }

    public boolean supportsNormalizedKey() {
        return this.numLeadingNormalizableKeys > 0;
    }

    public int getNormalizeKeyLen() {
        return this.normalizableKeyPrefixLen;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return this.numLeadingNormalizableKeys < this.keyFields.length || this.normalizableKeyPrefixLen == Integer.MAX_VALUE || this.normalizableKeyPrefixLen > keyBytes;
    }

    public void putNormalizedKey(T value, MemorySegment target, int offset, int numBytes) {
        int i = 0;
        try {
            while (i < this.numLeadingNormalizableKeys & numBytes > 0) {
                int len = this.normalizedKeyLengths[i];
                len = numBytes >= len ? len : numBytes;
                this.comparators[i].putNormalizedKey(this.keyFields[i].get(value), target, offset, len);
                numBytes -= len;
                offset += len;
                ++i;
            }
        }
        catch (IllegalAccessException iaex) {
            throw new RuntimeException("This should not happen since we call setAccesssible(true) in PojoTypeInfo.");
        }
        catch (NullPointerException npex) {
            throw new NullKeyFieldException(this.keyFields[i].toString());
        }
    }

    public boolean invertNormalizedKey() {
        return this.invertNormKey;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    public PojoComparator<T> duplicate() {
        return new PojoComparator<T>(this);
    }
}

