/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.operators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.base.GenericDataSourceBase;
import org.apache.flink.api.java.record.io.CollectionInputFormat;
import org.apache.flink.api.java.record.operators.OperatorInfoHelper;
import org.apache.flink.types.Record;

public class CollectionDataSource
extends GenericDataSourceBase<Record, GenericInputFormat<Record>> {
    private static String DEFAULT_NAME = "<Unnamed Collection Data Source>";

    public CollectionDataSource(CollectionInputFormat f, String name, Object ... data) {
        super((InputFormat)f, OperatorInfoHelper.source(), name);
        ArrayList<Object> tmp = new ArrayList<Object>();
        for (Object o : data) {
            tmp.add(o);
        }
        this.checkFormat(tmp);
        f.setData(tmp);
    }

    public CollectionDataSource(CollectionInputFormat f, String name, Object[][] data) {
        super((InputFormat)f, OperatorInfoHelper.source(), name);
        ArrayList<Object[]> tmp = new ArrayList<Object[]>();
        for (Object[] o : data) {
            tmp.add(o);
        }
        this.checkFormat(tmp);
        f.setData(tmp);
    }

    public CollectionDataSource(CollectionInputFormat f, Collection<?> data, String name) {
        super((InputFormat)f, OperatorInfoHelper.source(), name);
        this.checkFormat(data);
        f.setData(data);
    }

    public <T extends Iterator<?>, Serializable> CollectionDataSource(CollectionInputFormat f, T data, String name) {
        super((InputFormat)f, OperatorInfoHelper.source(), name);
        f.setIter(data);
    }

    public CollectionDataSource(String name, Object ... args) {
        this(new CollectionInputFormat(), name, args);
    }

    public CollectionDataSource(String name, Object[][] args) {
        this(new CollectionInputFormat(), name, args);
    }

    public CollectionDataSource(Collection<?> args, String name) {
        this(new CollectionInputFormat(), (Iterator)((Object)args), name);
    }

    public <T extends Iterator<?>, Serializable> CollectionDataSource(T args, String name) {
        this(new CollectionInputFormat(), args, name);
    }

    public CollectionDataSource(Object ... args) {
        this(new CollectionInputFormat(), args);
    }

    public CollectionDataSource(CollectionInputFormat f, Object ... data) {
        super((InputFormat)f, OperatorInfoHelper.source(), DEFAULT_NAME);
        if (data.length == 1 && data[0] instanceof Iterator) {
            f.setIter((Iterator)data[0]);
        } else if (data.length == 1 && data[0] instanceof Collection) {
            this.checkFormat((Collection)data[0]);
            f.setData((Collection)data[0]);
        } else {
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (Object o : data) {
                tmp.add(o);
            }
            this.checkFormat(tmp);
            f.setData(tmp);
        }
    }

    private <T> void checkFormat(Collection<T> c) {
        Class<?> type = null;
        ArrayList typeList = new ArrayList();
        for (T o : c) {
            if (type != null && !type.equals(o.getClass())) {
                throw new RuntimeException("elements of input list should have the same type");
            }
            type = o.getClass();
            if (typeList.size() == 0 && o.getClass().isArray()) {
                for (Object s : (Object[])o) {
                    typeList.add(s.getClass());
                }
            } else if (o.getClass().isArray()) {
                int index = 0;
                if (((Object[])o).length != typeList.size()) {
                    throw new RuntimeException("elements of input list should have the same size");
                }
                for (Object s : (Object[])o) {
                    if (s.getClass().equals(typeList.get(index++))) continue;
                    throw new RuntimeException("elements of input list should have the same type");
                }
            }
            if (typeList.size() == 0 && o instanceof Collection) {
                for (Object s : (Collection)o) {
                    typeList.add(s.getClass());
                }
                continue;
            }
            if (!(o instanceof Collection)) continue;
            int index = 0;
            for (Object s : (Collection)o) {
                if (s.getClass().equals(typeList.get(index++))) continue;
                throw new RuntimeException("elements of input list should have the same type");
            }
            if (index == typeList.size()) continue;
            throw new RuntimeException("elements of input list should have the same size");
        }
    }
}

