/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.operators;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.FileDataSinkBase;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.typeutils.RecordTypeInfo;
import org.apache.flink.types.NothingTypeInfo;
import org.apache.flink.types.Record;
import org.apache.flink.types.TypeInformation;

public class FileDataSink
extends FileDataSinkBase<Record> {
    private static String DEFAULT_NAME = "<Unnamed File Data Sink>";

    public FileDataSink(FileOutputFormat<Record> f, String filePath, String name) {
        super(f, new UnaryOperatorInformation((TypeInformation)new RecordTypeInfo(), (TypeInformation)new NothingTypeInfo()), filePath, name);
    }

    public FileDataSink(FileOutputFormat<Record> f, String filePath) {
        this(f, filePath, DEFAULT_NAME);
    }

    public FileDataSink(FileOutputFormat<Record> f, String filePath, Operator<Record> input) {
        this(f, filePath);
        this.setInput(input);
    }

    @Deprecated
    public FileDataSink(FileOutputFormat<Record> f, String filePath, List<Operator<Record>> input) {
        this(f, filePath, input, DEFAULT_NAME);
    }

    public FileDataSink(FileOutputFormat<Record> f, String filePath, Operator<Record> input, String name) {
        this(f, filePath, name);
        this.setInput(input);
    }

    @Deprecated
    public FileDataSink(FileOutputFormat<Record> f, String filePath, List<Operator<Record>> input, String name) {
        this(f, filePath, name);
        Validate.notNull(input, (String)"The input must not be null.", (Object[])new Object[0]);
        this.setInput(Operator.createUnionCascade(input));
    }

    public FileDataSink(Class<? extends FileOutputFormat<Record>> f, String filePath, String name) {
        super((UserCodeWrapper)new UserCodeClassWrapper(f), new UnaryOperatorInformation((TypeInformation)new RecordTypeInfo(), (TypeInformation)new NothingTypeInfo()), filePath, name);
    }

    public FileDataSink(Class<? extends FileOutputFormat<Record>> f, String filePath) {
        this(f, filePath, DEFAULT_NAME);
    }

    public FileDataSink(Class<? extends FileOutputFormat<Record>> f, String filePath, Operator<Record> input) {
        this(f, filePath, input, DEFAULT_NAME);
    }

    @Deprecated
    public FileDataSink(Class<? extends FileOutputFormat<Record>> f, String filePath, List<Operator<Record>> input) {
        this(f, filePath, input, DEFAULT_NAME);
    }

    public FileDataSink(Class<? extends FileOutputFormat<Record>> f, String filePath, Operator<Record> input, String name) {
        this(f, filePath, name);
        this.setInput(input);
    }

    @Deprecated
    public FileDataSink(Class<? extends FileOutputFormat<Record>> f, String filePath, List<Operator<Record>> input, String name) {
        this(f, filePath, name);
        Validate.notNull(input, (String)"The inputs must not be null.", (Object[])new Object[0]);
        this.setInput(Operator.createUnionCascade(input));
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String toString() {
        return this.filePath;
    }
}

