/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.DoubleCounter;
import org.apache.flink.api.common.accumulators.Histogram;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Value;

public abstract class WrappingFunction<T extends Function>
extends AbstractRichFunction {
    private static final long serialVersionUID = 1L;
    protected T wrappedFunction;

    protected WrappingFunction(T wrappedFunction) {
        this.wrappedFunction = wrappedFunction;
    }

    public void open(Configuration parameters) throws Exception {
        FunctionUtils.openFunction(this.wrappedFunction, (Configuration)parameters);
    }

    public void close() throws Exception {
        FunctionUtils.closeFunction(this.wrappedFunction);
    }

    public void setRuntimeContext(RuntimeContext t) {
        super.setRuntimeContext(t);
        if (t instanceof IterationRuntimeContext) {
            FunctionUtils.setFunctionRuntimeContext(this.wrappedFunction, (RuntimeContext)new WrappingIterationRuntimeContext(t));
        } else {
            FunctionUtils.setFunctionRuntimeContext(this.wrappedFunction, (RuntimeContext)new WrappingRuntimeContext(t));
        }
    }

    public T getWrappedFunction() {
        return this.wrappedFunction;
    }

    private static class WrappingIterationRuntimeContext
    extends WrappingRuntimeContext
    implements IterationRuntimeContext {
        protected WrappingIterationRuntimeContext(RuntimeContext context) {
            super(context);
        }

        public int getSuperstepNumber() {
            return ((IterationRuntimeContext)this.context).getSuperstepNumber();
        }

        public <T extends Aggregator<?>> T getIterationAggregator(String name) {
            return (T)((IterationRuntimeContext)this.context).getIterationAggregator(name);
        }

        public <T extends Value> T getPreviousIterationAggregate(String name) {
            return (T)((IterationRuntimeContext)this.context).getPreviousIterationAggregate(name);
        }
    }

    private static class WrappingRuntimeContext
    implements RuntimeContext {
        protected final RuntimeContext context;

        protected WrappingRuntimeContext(RuntimeContext context) {
            this.context = context;
        }

        public String getTaskName() {
            return this.context.getTaskName();
        }

        public int getNumberOfParallelSubtasks() {
            return this.context.getNumberOfParallelSubtasks();
        }

        public int getIndexOfThisSubtask() {
            return this.context.getIndexOfThisSubtask();
        }

        public <V, A> void addAccumulator(String name, Accumulator<V, A> accumulator) {
            this.context.addAccumulator(name, accumulator);
        }

        public <V, A> Accumulator<V, A> getAccumulator(String name) {
            return this.context.getAccumulator(name);
        }

        public HashMap<String, Accumulator<?, ?>> getAllAccumulators() {
            return this.context.getAllAccumulators();
        }

        public IntCounter getIntCounter(String name) {
            return this.context.getIntCounter(name);
        }

        public LongCounter getLongCounter(String name) {
            return this.context.getLongCounter(name);
        }

        public DoubleCounter getDoubleCounter(String name) {
            return this.context.getDoubleCounter(name);
        }

        public Histogram getHistogram(String name) {
            return this.context.getHistogram(name);
        }

        public <RT> Collection<RT> getBroadcastVariable(String name) {
            Collection refColl = this.context.getBroadcastVariable(name);
            ArrayList list = new ArrayList(refColl.size());
            for (Object e : refColl) {
                list.add(e);
            }
            return list;
        }

        public DistributedCache getDistributedCache() {
            return this.context.getDistributedCache();
        }
    }
}

