/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.record;

import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.java.typeutils.runtime.record.RecordComparator;
import org.apache.flink.api.java.typeutils.runtime.record.RecordPairComparator;
import org.apache.flink.types.Key;
import org.apache.flink.types.Record;

public class RecordPairComparatorFactory
implements TypePairComparatorFactory<Record, Record> {
    private static final RecordPairComparatorFactory INSTANCE = new RecordPairComparatorFactory();

    public static final RecordPairComparatorFactory get() {
        return INSTANCE;
    }

    public TypePairComparator<Record, Record> createComparator12(TypeComparator<Record> comparator1, TypeComparator<Record> comparator2) {
        if (!(comparator1 instanceof RecordComparator) || !(comparator2 instanceof RecordComparator)) {
            throw new IllegalArgumentException("Cannot instantiate pair comparator from the given comparators.");
        }
        RecordComparator prc1 = (RecordComparator)comparator1;
        RecordComparator prc2 = (RecordComparator)comparator2;
        int[] pos1 = prc1.getKeyPositions();
        int[] pos2 = prc2.getKeyPositions();
        Class<? extends Key<?>>[] types1 = prc1.getKeyTypes();
        Class<? extends Key<?>>[] types2 = prc2.getKeyTypes();
        RecordPairComparatorFactory.checkComparators(pos1, pos2, types1, types2);
        return new RecordPairComparator(pos1, pos2, types1);
    }

    public TypePairComparator<Record, Record> createComparator21(TypeComparator<Record> comparator1, TypeComparator<Record> comparator2) {
        if (!(comparator1 instanceof RecordComparator) || !(comparator2 instanceof RecordComparator)) {
            throw new IllegalArgumentException("Cannot instantiate pair comparator from the given comparators.");
        }
        RecordComparator prc1 = (RecordComparator)comparator1;
        RecordComparator prc2 = (RecordComparator)comparator2;
        int[] pos1 = prc1.getKeyPositions();
        int[] pos2 = prc2.getKeyPositions();
        Class<? extends Key<?>>[] types1 = prc1.getKeyTypes();
        Class<? extends Key<?>>[] types2 = prc2.getKeyTypes();
        RecordPairComparatorFactory.checkComparators(pos1, pos2, types1, types2);
        return new RecordPairComparator(pos2, pos1, types1);
    }

    private static final void checkComparators(int[] pos1, int[] pos2, Class<? extends Key<?>>[] types1, Class<? extends Key<?>>[] types2) {
        if (pos1.length != pos2.length || types1.length != types2.length) {
            throw new IllegalArgumentException("The given pair of RecordComparators does not operate on the same number of fields.");
        }
        for (int i = 0; i < types1.length; ++i) {
            if (types1[i].equals(types2[i])) continue;
            throw new IllegalArgumentException("The given pair of RecordComparators does not operates on different data types.");
        }
    }
}

