/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;

public final class TupleLeadingFieldComparator<T extends Tuple, K>
extends TypeComparator<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TypeComparator<K> comparator;

    public TupleLeadingFieldComparator(TypeComparator<K> comparator) {
        this.comparator = comparator;
    }

    public TypeComparator<K> getComparator() {
        return this.comparator;
    }

    public int hash(T value) {
        return this.comparator.hash(((Tuple)value).getField(0));
    }

    public void setReference(T toCompare) {
        this.comparator.setReference(((Tuple)toCompare).getField(0));
    }

    public boolean equalToReference(T candidate) {
        return this.comparator.equalToReference(((Tuple)candidate).getField(0));
    }

    public int compareToReference(TypeComparator<T> referencedComparator) {
        return this.comparator.compareToReference(((TupleLeadingFieldComparator)referencedComparator).comparator);
    }

    public int compare(T first, T second) {
        return this.comparator.compare(((Tuple)first).getField(0), ((Tuple)second).getField(0));
    }

    public int compare(DataInputView firstSource, DataInputView secondSource) throws IOException {
        return this.comparator.compare(firstSource, secondSource);
    }

    public boolean supportsNormalizedKey() {
        return this.comparator.supportsNormalizedKey();
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    public int getNormalizeKeyLen() {
        return this.comparator.getNormalizeKeyLen();
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return this.comparator.isNormalizedKeyPrefixOnly(keyBytes);
    }

    public void putNormalizedKey(T record, MemorySegment target, int offset, int numBytes) {
        this.comparator.putNormalizedKey(((Tuple)record).getField(0), target, offset, numBytes);
    }

    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean invertNormalizedKey() {
        return this.comparator.invertNormalizedKey();
    }

    public TypeComparator<T> duplicate() {
        return new TupleLeadingFieldComparator<T, K>(this.comparator.duplicate());
    }

    protected TypeComparator<K> getFieldComparator() {
        return this.comparator;
    }
}

