/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.operators;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.RecordOperator;
import org.apache.flink.api.common.operators.base.CoGroupOperatorBase;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.record.functions.FunctionAnnotation;
import org.apache.flink.api.java.record.operators.DeltaIteration;
import org.apache.flink.api.java.record.operators.OperatorInfoHelper;
import org.apache.flink.types.Key;
import org.apache.flink.types.Record;
import org.apache.flink.util.Collector;
import org.apache.flink.util.InstantiationUtil;

public class CoGroupOperator
extends CoGroupOperatorBase<Record, Record, Record, CoGroupFunction<Record, Record, Record>>
implements RecordOperator {
    private final Class<? extends Key<?>>[] keyTypes;

    public static Builder builder(org.apache.flink.api.java.record.functions.CoGroupFunction udf, Class<? extends Key<?>> keyClass, int keyColumn1, int keyColumn2) {
        WrappingCoGroupFunction wrapper = new WrappingCoGroupFunction(udf);
        return new Builder((UserCodeWrapper<CoGroupFunction<Record, Record, Record>>)new UserCodeObjectWrapper((Object)wrapper), keyClass, keyColumn1, keyColumn2);
    }

    public static Builder builder(Class<? extends org.apache.flink.api.java.record.functions.CoGroupFunction> udf, Class<? extends Key<?>> keyClass, int keyColumn1, int keyColumn2) {
        WrappingClassCoGroupFunction wrapper = new WrappingClassCoGroupFunction(udf);
        return new Builder((UserCodeWrapper<CoGroupFunction<Record, Record, Record>>)new UserCodeObjectWrapper((Object)wrapper), keyClass, keyColumn1, keyColumn2);
    }

    protected CoGroupOperator(Builder builder) {
        super(builder.udf, OperatorInfoHelper.binary(), builder.getKeyColumnsArray1(), builder.getKeyColumnsArray2(), builder.name);
        int[] positions;
        this.keyTypes = builder.getKeyClassesArray();
        if (builder.inputs1 != null && !builder.inputs1.isEmpty()) {
            this.setFirstInput(Operator.createUnionCascade((List)builder.inputs1));
        }
        if (builder.inputs2 != null && !builder.inputs2.isEmpty()) {
            this.setSecondInput(Operator.createUnionCascade((List)builder.inputs2));
        }
        if (this.input1 instanceof DeltaIteration.SolutionSetPlaceHolder) {
            positions = this.getKeyColumns(0);
            ((DeltaIteration.SolutionSetPlaceHolder)this.input1).checkJoinKeyFields(positions);
        }
        if (this.input2 instanceof DeltaIteration.SolutionSetPlaceHolder) {
            positions = this.getKeyColumns(1);
            ((DeltaIteration.SolutionSetPlaceHolder)this.input2).checkJoinKeyFields(positions);
        }
        this.setBroadcastVariables(builder.broadcastInputs);
        this.setGroupOrderForInputOne(builder.secondaryOrder1);
        this.setGroupOrderForInputTwo(builder.secondaryOrder2);
        org.apache.flink.api.java.record.functions.CoGroupFunction function = (org.apache.flink.api.java.record.functions.CoGroupFunction)((Object)((WrappingCoGroupFunction)((Object)builder.udf.getUserCodeObject())).getWrappedFunction());
        this.setSemanticProperties(FunctionAnnotation.readDualConstantAnnotations(new UserCodeObjectWrapper((Object)function)));
    }

    public Class<? extends Key<?>>[] getKeyClasses() {
        return this.keyTypes;
    }

    public static final class WrappingClassCoGroupFunction
    extends WrappingCoGroupFunction {
        private static final long serialVersionUID = 1L;

        public WrappingClassCoGroupFunction(Class<? extends org.apache.flink.api.java.record.functions.CoGroupFunction> reducer) {
            super((org.apache.flink.api.java.record.functions.CoGroupFunction)((Object)InstantiationUtil.instantiate(reducer)));
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(((Object)((Object)((org.apache.flink.api.java.record.functions.CoGroupFunction)this.wrappedFunction))).getClass());
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Class clazz = (Class)in.readObject();
            this.wrappedFunction = (org.apache.flink.api.java.record.functions.CoGroupFunction)((Object)InstantiationUtil.instantiate((Class)clazz));
        }
    }

    public static class WrappingCoGroupFunction
    extends WrappingFunction<org.apache.flink.api.java.record.functions.CoGroupFunction>
    implements CoGroupFunction<Record, Record, Record> {
        private static final long serialVersionUID = 1L;

        public WrappingCoGroupFunction(org.apache.flink.api.java.record.functions.CoGroupFunction coGrouper) {
            super(coGrouper);
        }

        public void coGroup(Iterable<Record> records1, Iterable<Record> records2, Collector<Record> out) throws Exception {
            ((org.apache.flink.api.java.record.functions.CoGroupFunction)this.wrappedFunction).coGroup(records1.iterator(), records2.iterator(), out);
        }
    }

    public static class Builder {
        private final UserCodeWrapper<CoGroupFunction<Record, Record, Record>> udf;
        private final List<Class<? extends Key<?>>> keyClasses;
        private final List<Integer> keyColumns1;
        private final List<Integer> keyColumns2;
        private List<Operator<Record>> inputs1;
        private List<Operator<Record>> inputs2;
        private Map<String, Operator<Record>> broadcastInputs;
        private Ordering secondaryOrder1;
        private Ordering secondaryOrder2;
        private String name;

        protected Builder(UserCodeWrapper<CoGroupFunction<Record, Record, Record>> udf, Class<? extends Key<?>> keyClass, int keyColumn1, int keyColumn2) {
            this.udf = udf;
            this.keyClasses = new ArrayList();
            this.keyClasses.add(keyClass);
            this.keyColumns1 = new ArrayList<Integer>();
            this.keyColumns1.add(keyColumn1);
            this.keyColumns2 = new ArrayList<Integer>();
            this.keyColumns2.add(keyColumn2);
            this.inputs1 = new ArrayList<Operator<Record>>();
            this.inputs2 = new ArrayList<Operator<Record>>();
            this.broadcastInputs = new HashMap<String, Operator<Record>>();
        }

        protected Builder(UserCodeWrapper<CoGroupFunction<Record, Record, Record>> udf) {
            this.udf = udf;
            this.keyClasses = new ArrayList();
            this.keyColumns1 = new ArrayList<Integer>();
            this.keyColumns2 = new ArrayList<Integer>();
            this.inputs1 = new ArrayList<Operator<Record>>();
            this.inputs2 = new ArrayList<Operator<Record>>();
            this.broadcastInputs = new HashMap<String, Operator<Record>>();
        }

        private int[] getKeyColumnsArray1() {
            int[] result = new int[this.keyColumns1.size()];
            for (int i = 0; i < this.keyColumns1.size(); ++i) {
                result[i] = this.keyColumns1.get(i);
            }
            return result;
        }

        private int[] getKeyColumnsArray2() {
            int[] result = new int[this.keyColumns2.size()];
            for (int i = 0; i < this.keyColumns2.size(); ++i) {
                result[i] = this.keyColumns2.get(i);
            }
            return result;
        }

        private Class<? extends Key<?>>[] getKeyClassesArray() {
            return this.keyClasses.toArray(new Class[this.keyClasses.size()]);
        }

        public Builder keyField(Class<? extends Key<?>> keyClass, int keyColumn1, int keyColumn2) {
            this.keyClasses.add(keyClass);
            this.keyColumns1.add(keyColumn1);
            this.keyColumns2.add(keyColumn2);
            return this;
        }

        public Builder secondaryOrder1(Ordering order) {
            this.secondaryOrder1 = order;
            return this;
        }

        public Builder secondaryOrder2(Ordering order) {
            this.secondaryOrder2 = order;
            return this;
        }

        public Builder input1(Operator<Record> input) {
            Validate.notNull(input, (String)"The input must not be null", (Object[])new Object[0]);
            this.inputs1.clear();
            this.inputs1.add(input);
            return this;
        }

        public Builder input1(Operator<Record> ... inputs) {
            this.inputs1.clear();
            for (Operator<Record> c : inputs) {
                this.inputs1.add(c);
            }
            return this;
        }

        public Builder input2(Operator<Record> input) {
            Validate.notNull(input, (String)"The input must not be null", (Object[])new Object[0]);
            this.inputs2.clear();
            this.inputs2.add(input);
            return this;
        }

        public Builder input2(Operator<Record> ... inputs) {
            this.inputs2.clear();
            for (Operator<Record> c : inputs) {
                this.inputs2.add(c);
            }
            return this;
        }

        public Builder inputs1(List<Operator<Record>> inputs) {
            this.inputs1 = inputs;
            return this;
        }

        public Builder inputs2(List<Operator<Record>> inputs) {
            this.inputs2 = inputs;
            return this;
        }

        public Builder setBroadcastVariable(String name, Operator<Record> input) {
            this.broadcastInputs.put(name, input);
            return this;
        }

        public Builder setBroadcastVariables(Map<String, Operator<Record>> inputs) {
            this.broadcastInputs.clear();
            this.broadcastInputs.putAll(inputs);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public CoGroupOperator build() {
            if (this.keyClasses.size() <= 0) {
                throw new IllegalStateException("At least one key attribute has to be set.");
            }
            if (this.name == null) {
                this.name = this.udf.getUserCodeClass().getName();
            }
            return new CoGroupOperator(this);
        }
    }
}

