/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.FlatMapOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.typeutils.TypeExtractor;

public class FlatMapOperator<IN, OUT>
extends SingleInputUdfOperator<IN, OUT, FlatMapOperator<IN, OUT>> {
    protected final FlatMapFunction<IN, OUT> function;

    public FlatMapOperator(DataSet<IN> input, FlatMapFunction<IN, OUT> function) {
        super(input, TypeExtractor.getFlatMapReturnTypes(function, input.getType()));
        this.function = function;
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    @Override
    protected FlatMapOperatorBase<IN, OUT, FlatMapFunction<IN, OUT>> translateToDataFlow(Operator<IN> input) {
        String name = this.getName() != null ? this.getName() : this.function.getClass().getName();
        FlatMapOperatorBase po = new FlatMapOperatorBase(this.function, new UnaryOperatorInformation(this.getInputType(), this.getResultType()), name);
        po.setInput(input);
        if (this.getParallelism() > 0) {
            po.setDegreeOfParallelism(this.getParallelism());
        } else {
            po.setDegreeOfParallelism(input.getDegreeOfParallelism());
        }
        return po;
    }
}

