/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.PlanExecutor;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.util.LogUtils;
import org.apache.log4j.Level;

public class LocalEnvironment
extends ExecutionEnvironment {
    private boolean logging = false;

    public LocalEnvironment() {
        if (!ExecutionEnvironment.localExecutionIsAllowed()) {
            throw new InvalidProgramException("The LocalEnvironment cannot be used when submitting a program through a client.");
        }
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        JavaPlan p = this.createProgramPlan(jobName);
        PlanExecutor executor = PlanExecutor.createLocalExecutor();
        this.initLogging();
        return executor.executePlan((Plan)p);
    }

    @Override
    public String getExecutionPlan() throws Exception {
        JavaPlan p = this.createProgramPlan();
        PlanExecutor executor = PlanExecutor.createLocalExecutor();
        this.initLogging();
        return executor.getOptimizerPlanAsJSON((Plan)p);
    }

    public void enableLogging() {
        this.logging = true;
    }

    public void disableLogging() {
        this.logging = false;
    }

    public boolean isLoggingEnabled() {
        return this.logging;
    }

    private void initLogging() {
        LogUtils.initializeDefaultConsoleLogger((Level)(this.logging ? Level.INFO : Level.OFF));
    }

    public String toString() {
        return "Local Environment (DOP = " + (this.getDegreeOfParallelism() == -1 ? "default" : Integer.valueOf(this.getDegreeOfParallelism())) + ") : " + this.getIdString();
    }
}

