/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class TupleSerializer<T extends Tuple>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> tupleClass;
    private final TypeSerializer<Object>[] fieldSerializers;
    private final int arity;
    private final boolean stateful;

    public TupleSerializer(Class<T> tupleClass, TypeSerializer<?>[] fieldSerializers) {
        this.tupleClass = tupleClass;
        this.fieldSerializers = fieldSerializers;
        this.arity = fieldSerializers.length;
        boolean stateful = false;
        for (TypeSerializer<?> ser : fieldSerializers) {
            if (!ser.isStateful()) continue;
            stateful = true;
            break;
        }
        this.stateful = stateful;
    }

    public boolean isImmutableType() {
        return false;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public T createInstance() {
        try {
            Tuple t = (Tuple)this.tupleClass.newInstance();
            for (int i = 0; i < this.arity; ++i) {
                t.setField(this.fieldSerializers[i].createInstance(), i);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate tuple.", e);
        }
    }

    public T copy(T from, T reuse) {
        for (int i = 0; i < this.arity; ++i) {
            Object copy = this.fieldSerializers[i].copy(((Tuple)from).getField(i), ((Tuple)reuse).getField(i));
            ((Tuple)reuse).setField((Object)copy, i);
        }
        return (T)reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            Object o = ((Tuple)value).getField(i);
            this.fieldSerializers[i].serialize(o, target);
        }
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            Object field = this.fieldSerializers[i].deserialize(((Tuple)reuse).getField(i), source);
            ((Tuple)reuse).setField((Object)field, i);
        }
        return (T)reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            this.fieldSerializers[i].copy(source, target);
        }
    }

    public int hashCode() {
        int hashCode = this.arity * 47;
        for (TypeSerializer<Object> ser : this.fieldSerializers) {
            hashCode = hashCode << 7 | hashCode >>> -7;
            hashCode += ser.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TupleSerializer) {
            TupleSerializer otherTS = (TupleSerializer)((Object)obj);
            return otherTS.tupleClass == this.tupleClass && Arrays.deepEquals(this.fieldSerializers, otherTS.fieldSerializers);
        }
        return false;
    }
}

