/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.AtomicType;
import org.apache.flink.api.java.typeutils.BasicTypeInfo;
import org.apache.flink.api.java.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleLeadingFieldComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.types.TypeInformation;

public class TupleTypeInfo<T extends Tuple>
extends TypeInformation<T>
implements CompositeType<T> {
    private final TypeInformation<?>[] types;
    private final Class<T> tupleType;
    private static final Class<?>[] CLASSES = new Class[]{Tuple1.class, Tuple2.class, Tuple3.class, Tuple4.class, Tuple5.class, Tuple6.class, Tuple7.class, Tuple8.class, Tuple9.class, Tuple10.class, Tuple11.class, Tuple12.class, Tuple13.class, Tuple14.class, Tuple15.class, Tuple16.class, Tuple17.class, Tuple18.class, Tuple19.class, Tuple20.class, Tuple21.class, Tuple22.class, Tuple23.class, Tuple24.class, Tuple25.class};

    public TupleTypeInfo(TypeInformation<?> ... types) {
        if (types == null || types.length == 0 || types.length > 25) {
            throw new IllegalArgumentException();
        }
        Class<?> typeClass = CLASSES[types.length - 1];
        this.types = types;
        this.tupleType = typeClass;
    }

    public TupleTypeInfo(Class<T> tupleType, TypeInformation<?> ... types) {
        if (types == null || types.length == 0 || types.length > 25) {
            throw new IllegalArgumentException();
        }
        this.tupleType = tupleType;
        this.types = types;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return true;
    }

    public int getArity() {
        return this.types.length;
    }

    public Class<T> getTypeClass() {
        return this.tupleType;
    }

    public <X> TypeInformation<X> getTypeAt(int pos) {
        if (pos < 0 || pos >= this.types.length) {
            throw new IndexOutOfBoundsException();
        }
        TypeInformation<?> typed = this.types[pos];
        return typed;
    }

    public boolean isKeyType() {
        return false;
    }

    public TupleSerializer<T> createSerializer() {
        TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
        for (int i = 0; i < this.types.length; ++i) {
            fieldSerializers[i] = this.types[i].createSerializer();
        }
        Class<T> tupleClass = this.getTypeClass();
        return new TupleSerializer<T>(tupleClass, fieldSerializers);
    }

    @Override
    public TypeComparator<T> createComparator(int[] logicalKeyFields, boolean[] orders) {
        if (logicalKeyFields == null || orders == null || logicalKeyFields.length != orders.length || logicalKeyFields.length > this.types.length) {
            throw new IllegalArgumentException();
        }
        if (logicalKeyFields.length == 1 && logicalKeyFields[0] == 0) {
            return TupleTypeInfo.createLeadingFieldComparator(orders[0], this.types[0]);
        }
        int maxKey = -1;
        for (int key : logicalKeyFields) {
            maxKey = Math.max(key, maxKey);
        }
        if (maxKey >= this.types.length) {
            throw new IllegalArgumentException("The key position " + maxKey + " is out of range for Tuple" + this.types.length);
        }
        TypeComparator[] fieldComparators = new TypeComparator[logicalKeyFields.length];
        for (int i = 0; i < logicalKeyFields.length; ++i) {
            int keyPos = logicalKeyFields[i];
            if (!this.types[keyPos].isKeyType() || !(this.types[keyPos] instanceof AtomicType)) {
                throw new IllegalArgumentException("The field at position " + i + " (" + this.types[keyPos] + ") is no atomic key type.");
            }
            fieldComparators[i] = ((AtomicType)this.types[keyPos]).createComparator(orders[i]);
        }
        TypeSerializer[] fieldSerializers = new TypeSerializer[maxKey + 1];
        for (int i = 0; i <= maxKey; ++i) {
            fieldSerializers[i] = this.types[i].createSerializer();
        }
        return new TupleComparator(logicalKeyFields, fieldComparators, fieldSerializers);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TupleTypeInfo) {
            TupleTypeInfo other = (TupleTypeInfo)obj;
            return (this.tupleType == null && other.tupleType == null || this.tupleType.equals(other.tupleType)) && Arrays.deepEquals(this.types, other.types);
        }
        return false;
    }

    public int hashCode() {
        return this.types.hashCode() ^ Arrays.deepHashCode(this.types);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("Tuple");
        bld.append(this.types.length).append('<');
        bld.append(this.types[0]);
        for (int i = 1; i < this.types.length; ++i) {
            bld.append(", ").append(this.types[i]);
        }
        bld.append('>');
        return bld.toString();
    }

    public static <X extends Tuple> TupleTypeInfo<X> getBasicTupleTypeInfo(Class<?> ... basicTypes) {
        if (basicTypes == null || basicTypes.length == 0) {
            throw new IllegalArgumentException();
        }
        TypeInformation[] infos = new TypeInformation[basicTypes.length];
        for (int i = 0; i < infos.length; ++i) {
            Class<?> type = basicTypes[i];
            if (type == null) {
                throw new IllegalArgumentException("Type at position " + i + " is null.");
            }
            BasicTypeInfo<?> info = BasicTypeInfo.getInfoFor(type);
            if (info == null) {
                throw new IllegalArgumentException("Type at position " + i + " is not a basic type.");
            }
            infos[i] = info;
        }
        TupleTypeInfo tupleInfo = new TupleTypeInfo(infos);
        return tupleInfo;
    }

    private static final <T extends Tuple, K> TypeComparator<T> createLeadingFieldComparator(boolean ascending, TypeInformation<?> info) {
        if (!info.isKeyType() || !(info instanceof AtomicType)) {
            throw new IllegalArgumentException("The field at position 0 (" + info + ") is no atomic key type.");
        }
        AtomicType typedInfo = (AtomicType)info;
        return new TupleLeadingFieldComparator(typedInfo.createComparator(ascending));
    }
}

