/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.record.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.api.java.record.io.DelimitedInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Record;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;

public class TextInputFormat
extends DelimitedInputFormat {
    private static final long serialVersionUID = 1L;
    public static final String CHARSET_NAME = "textformat.charset";
    public static final String FIELD_POS = "textformat.pos";
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    private static final Log LOG = LogFactory.getLog(TextInputFormat.class);
    protected final StringValue theString = new StringValue();
    protected transient CharsetDecoder decoder;
    protected transient ByteBuffer byteWrapper;
    protected transient int pos;
    protected transient boolean ascii;
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte NEW_LINE = 10;

    public void configure(Configuration parameters) {
        super.configure(parameters);
        String charsetName = parameters.getString(CHARSET_NAME, DEFAULT_CHARSET_NAME);
        if (charsetName == null || !Charset.isSupported(charsetName)) {
            throw new RuntimeException("Unsupported charset: " + charsetName);
        }
        if (charsetName.equals("ISO-8859-1") || charsetName.equalsIgnoreCase("ASCII")) {
            this.ascii = true;
        } else {
            this.decoder = Charset.forName(charsetName).newDecoder();
            this.byteWrapper = ByteBuffer.allocate(1);
        }
        this.pos = parameters.getInteger(FIELD_POS, 0);
        if (this.pos < 0) {
            throw new RuntimeException("Illegal configuration value for the target position: " + this.pos);
        }
    }

    @Override
    public Record readRecord(Record reuse, byte[] bytes, int offset, int numBytes) {
        StringValue str = this.theString;
        if (this.getDelimiter() != null && this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10 && offset + numBytes >= 1 && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        if (this.ascii) {
            str.setValueAscii(bytes, offset, numBytes);
        } else {
            ByteBuffer byteWrapper = this.byteWrapper;
            if (bytes != byteWrapper.array()) {
                this.byteWrapper = byteWrapper = ByteBuffer.wrap(bytes, 0, bytes.length);
            }
            byteWrapper.limit(offset + numBytes);
            byteWrapper.position(offset);
            try {
                CharBuffer result = this.decoder.decode(byteWrapper);
                str.setValue(result);
            }
            catch (CharacterCodingException e) {
                byte[] copy = new byte[numBytes];
                System.arraycopy(bytes, offset, copy, 0, numBytes);
                LOG.warn((Object)("Line could not be encoded: " + Arrays.toString(copy)), (Throwable)e);
                return null;
            }
        }
        reuse.clear();
        reuse.setField(this.pos, (Value)str);
        return reuse;
    }
}

