/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.base.GenericDataSourceBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.types.TypeInformation;

public class DataSource<OUT>
extends DataSet<OUT> {
    private final InputFormat<OUT, ?> inputFormat;
    private String name;
    private int dop = -1;

    public DataSource(ExecutionEnvironment context, InputFormat<OUT, ?> inputFormat, TypeInformation<OUT> type) {
        super(context, type);
        if (inputFormat == null) {
            throw new IllegalArgumentException("The input format may not be null.");
        }
        this.inputFormat = inputFormat;
    }

    public InputFormat<OUT, ?> getInputFormat() {
        return this.inputFormat;
    }

    public DataSource<OUT> name(String name) {
        this.name = name;
        return this;
    }

    public int getParallelism() {
        return this.dop;
    }

    public DataSource<OUT> setParallelism(int dop) {
        if (dop < 1) {
            throw new IllegalArgumentException("The parallelism of an operator must be at least 1.");
        }
        this.dop = dop;
        return this;
    }

    protected GenericDataSourceBase<OUT, ?> translateToDataFlow() {
        String name;
        String string = name = this.name != null ? this.name : this.inputFormat.toString();
        if (name.length() > 100) {
            name = name.substring(0, 100);
        }
        GenericDataSourceBase source = new GenericDataSourceBase(this.inputFormat, new OperatorInformation(this.getType()), name);
        source.setDegreeOfParallelism(this.dop);
        return source;
    }
}

