/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorRegistry;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.java.BulkIterationResultSet;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.SingleInputOperator;
import org.apache.flink.types.TypeInformation;
import org.apache.flink.types.Value;

public class IterativeDataSet<T>
extends SingleInputOperator<T, T, IterativeDataSet<T>> {
    private final AggregatorRegistry aggregators = new AggregatorRegistry();
    private int maxIterations;

    IterativeDataSet(ExecutionEnvironment context, TypeInformation<T> type, DataSet<T> input, int maxIterations) {
        super(input, type);
        this.maxIterations = maxIterations;
    }

    public DataSet<T> closeWith(DataSet<T> iterationResult) {
        return new BulkIterationResultSet(this.getExecutionEnvironment(), this.getType(), this, iterationResult);
    }

    public DataSet<T> closeWith(DataSet<T> iterationResult, DataSet<?> terminationCriterion) {
        return new BulkIterationResultSet(this.getExecutionEnvironment(), this.getType(), this, iterationResult, terminationCriterion);
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public IterativeDataSet<T> registerAggregator(String name, Aggregator<?> aggregator) {
        this.aggregators.registerAggregator(name, aggregator);
        return this;
    }

    public <X extends Value> IterativeDataSet<T> registerAggregationConvergenceCriterion(String name, Aggregator<X> aggregator, ConvergenceCriterion<X> convergenceCheck) {
        this.aggregators.registerAggregationConvergenceCriterion(name, aggregator, convergenceCheck);
        return this;
    }

    public AggregatorRegistry getAggregators() {
        return this.aggregators;
    }

    @Override
    protected org.apache.flink.api.common.operators.SingleInputOperator<T, T, ?> translateToDataFlow(Operator<T> input) {
        throw new RuntimeException("Error while creating the data flow plan for an iteration: The iteration end was not specified correctly.");
    }
}

