/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators.translation;

import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.GroupReduceOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.operators.translation.TupleUnwrappingIterator;
import org.apache.flink.api.java.operators.translation.TupleWrappingCollector;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;

public class PlanUnwrappingReduceGroupOperator<IN, OUT, K>
extends GroupReduceOperatorBase<Tuple2<K, IN>, OUT, GroupReduceFunction<Tuple2<K, IN>, OUT>> {
    public PlanUnwrappingReduceGroupOperator(GroupReduceFunction<IN, OUT> udf, Keys.SelectorFunctionKeys<IN, K> key, String name, TypeInformation<OUT> outType, TypeInformation<Tuple2<K, IN>> typeInfoWithKey, boolean combinable) {
        super((GroupReduceFunction)(combinable ? new TupleUnwrappingGroupCombinableGroupReducer((RichGroupReduceFunction)udf) : new TupleUnwrappingNonCombinableGroupReducer(udf)), new UnaryOperatorInformation(typeInfoWithKey, outType), key.computeLogicalKeyPositions(), name);
        super.setCombinable(combinable);
    }

    public static final class TupleUnwrappingNonCombinableGroupReducer<IN, OUT, K>
    extends WrappingFunction<GroupReduceFunction<IN, OUT>>
    implements GroupReduceFunction<Tuple2<K, IN>, OUT> {
        private static final long serialVersionUID = 1L;
        private final TupleUnwrappingIterator<IN, K> iter = new TupleUnwrappingIterator();

        private TupleUnwrappingNonCombinableGroupReducer(GroupReduceFunction<IN, OUT> wrapped) {
            super(wrapped);
        }

        public void reduce(Iterable<Tuple2<K, IN>> values, Collector<OUT> out) throws Exception {
            this.iter.set(values.iterator());
            ((GroupReduceFunction)this.wrappedFunction).reduce(this.iter, out);
        }

        public String toString() {
            return ((GroupReduceFunction)this.wrappedFunction).toString();
        }
    }

    @RichGroupReduceFunction.Combinable
    public static final class TupleUnwrappingGroupCombinableGroupReducer<IN, OUT, K>
    extends WrappingFunction<RichGroupReduceFunction<IN, OUT>>
    implements GroupReduceFunction<Tuple2<K, IN>, OUT>,
    GroupCombineFunction<Tuple2<K, IN>, Tuple2<K, IN>> {
        private static final long serialVersionUID = 1L;
        private TupleUnwrappingIterator<IN, K> iter = new TupleUnwrappingIterator();
        private TupleWrappingCollector<IN, K> coll = new TupleWrappingCollector<IN, K>(this.iter);

        private TupleUnwrappingGroupCombinableGroupReducer(RichGroupReduceFunction<IN, OUT> wrapped) {
            super(wrapped);
        }

        public void reduce(Iterable<Tuple2<K, IN>> values, Collector<OUT> out) throws Exception {
            this.iter.set(values.iterator());
            ((RichGroupReduceFunction)this.wrappedFunction).reduce(this.iter, out);
        }

        public void combine(Iterable<Tuple2<K, IN>> values, Collector<Tuple2<K, IN>> out) throws Exception {
            this.iter.set(values.iterator());
            this.coll.set(out);
            ((RichGroupReduceFunction)this.wrappedFunction).combine(this.iter, this.coll);
        }

        public String toString() {
            return ((RichGroupReduceFunction)this.wrappedFunction).toString();
        }
    }
}

