/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class PojoField
implements Serializable {
    private static final long serialVersionUID = 1975295846436559363L;
    private transient Field field;
    private final TypeInformation<?> type;

    public PojoField(Field field, TypeInformation<?> type) {
        this.field = Preconditions.checkNotNull(field);
        this.type = Preconditions.checkNotNull(type);
    }

    public Field getField() {
        return this.field;
    }

    public TypeInformation<?> getTypeInformation() {
        return this.type;
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeObject(this.field.getDeclaringClass());
        out.writeUTF(this.field.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String fieldName = in.readUTF();
        this.field = null;
        for (Class clazz = (Class)in.readObject(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                this.field = clazz.getDeclaredField(fieldName);
                this.field.setAccessible(true);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (this.field == null) {
            throw new RuntimeException("Class resolved at TaskManager is not compatible with class read during Plan setup. (" + fieldName + ")");
        }
    }

    public String toString() {
        return "PojoField " + this.field.getDeclaringClass() + "." + this.field.getName() + " (" + this.type + ")";
    }

    public boolean equals(Object obj) {
        if (obj instanceof PojoField) {
            PojoField other = (PojoField)obj;
            return other.canEqual(this) && this.type.equals(other.type) && Objects.equals(this.field, other.field);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.type);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof PojoField;
    }
}

