/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.java.BatchTableEnvironment;

public class WordCountSQL {
    public static void main(String[] args) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tEnv = BatchTableEnvironment.create((ExecutionEnvironment)env);
        DataSource input = env.fromElements((Object[])new WC[]{new WC("Hello", 1L), new WC("Ciao", 1L), new WC("Hello", 1L)});
        tEnv.registerDataSet("WordCount", (DataSet)input, "word, frequency");
        Table table = tEnv.sqlQuery("SELECT word, SUM(frequency) as frequency FROM WordCount GROUP BY word");
        DataSet result = tEnv.toDataSet(table, WC.class);
        result.print();
    }

    public static class WC {
        public String word;
        public long frequency;

        public WC() {
        }

        public WC(String word, long frequency) {
            this.word = word;
            this.frequency = frequency;
        }

        public String toString() {
            return "WC " + this.word + " " + this.frequency;
        }
    }
}

