/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java;

import org.apache.flink.api.java.CollectionEnvironment;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.java.BatchTableEnvironment;

public class WordCountTable {
    public static void main(String[] args) throws Exception {
        CollectionEnvironment env = ExecutionEnvironment.createCollectionsEnvironment();
        BatchTableEnvironment tEnv = TableEnvironment.getTableEnvironment((ExecutionEnvironment)env);
        DataSource input = env.fromElements((Object[])new WC[]{new WC("Hello", 1L), new WC("Ciao", 1L), new WC("Hello", 1L)});
        Table table = tEnv.fromDataSet((DataSet)input);
        Table filtered = table.groupBy("word").select("word, frequency.sum as frequency").filter("frequency = 2");
        DataSet result = tEnv.toDataSet(filtered, WC.class);
        result.print();
    }

    public static class WC {
        public String word;
        public long frequency;

        public WC() {
        }

        public WC(String word, long frequency) {
            this.word = word;
            this.frequency = frequency;
        }

        public String toString() {
            return "WC " + this.word + " " + this.frequency;
        }
    }
}

