/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.scala.basics;

import java.time.LocalDate;
import java.util.Iterator;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.examples.scala.basics.GettingStartedExample;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.RichInt$;

public final class GettingStartedExample$ {
    public static final GettingStartedExample$ MODULE$;

    static {
        new GettingStartedExample$();
    }

    public void main(String[] args) {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)settings);
        Table rawCustomers = env.fromValues(new Expression[]{package$.MODULE$.row(package$.MODULE$.string2Literal("Guillermo Smith"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.localDate2Literal(LocalDate.parse("1992-12-12")), package$.MODULE$.string2Literal("4081 Valley Road"), package$.MODULE$.string2Literal("08540"), package$.MODULE$.string2Literal("New Jersey"), package$.MODULE$.string2Literal("m"), package$.MODULE$.boolean2Literal(true), package$.MODULE$.int2Literal(0), package$.MODULE$.int2Literal(78), package$.MODULE$.int2Literal(3)})), package$.MODULE$.row(package$.MODULE$.string2Literal("Valeria Mendoza"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.localDate2Literal(LocalDate.parse("1970-03-28")), package$.MODULE$.string2Literal("1239  Rainbow Road"), package$.MODULE$.string2Literal("90017"), package$.MODULE$.string2Literal("Los Angeles"), package$.MODULE$.string2Literal("f"), package$.MODULE$.boolean2Literal(true), package$.MODULE$.int2Literal(9), package$.MODULE$.int2Literal(39), package$.MODULE$.int2Literal(0)})), package$.MODULE$.row(package$.MODULE$.string2Literal("Leann Holloway"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.localDate2Literal(LocalDate.parse("1989-05-21")), package$.MODULE$.string2Literal("2359 New Street"), package$.MODULE$.string2Literal("97401"), package$.MODULE$.string2Literal("Eugene"), null, package$.MODULE$.boolean2Literal(true), null, null, null})), package$.MODULE$.row(package$.MODULE$.string2Literal("Brandy Sanders"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.localDate2Literal(LocalDate.parse("1956-05-26")), package$.MODULE$.string2Literal("4891 Walkers-Ridge-Way"), package$.MODULE$.string2Literal("73119"), package$.MODULE$.string2Literal("Oklahoma City"), package$.MODULE$.string2Literal("m"), package$.MODULE$.boolean2Literal(false), package$.MODULE$.int2Literal(9), package$.MODULE$.int2Literal(39), package$.MODULE$.int2Literal(0)})), package$.MODULE$.row(package$.MODULE$.string2Literal("John Turner"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.localDate2Literal(LocalDate.parse("1982-10-02")), package$.MODULE$.string2Literal("2359 New Street"), package$.MODULE$.string2Literal("60605"), package$.MODULE$.string2Literal("Chicago"), package$.MODULE$.string2Literal("m"), package$.MODULE$.boolean2Literal(true), package$.MODULE$.int2Literal(12), package$.MODULE$.int2Literal(39), package$.MODULE$.int2Literal(0)})), package$.MODULE$.row(package$.MODULE$.string2Literal("Ellen Ortega"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.localDate2Literal(LocalDate.parse("1985-06-18")), package$.MODULE$.string2Literal("2448 Rodney STreet"), package$.MODULE$.string2Literal("85023"), package$.MODULE$.string2Literal("Phoenix"), package$.MODULE$.string2Literal("f"), package$.MODULE$.boolean2Literal(true), package$.MODULE$.int2Literal(0), package$.MODULE$.int2Literal(78), package$.MODULE$.int2Literal(3)}))});
        Table truncatedCustomers = rawCustomers.select(new Expression[]{package$.MODULE$.withColumns(package$.MODULE$.scalaRange2RangeExpression(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 7)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))});
        Table namedCustomers = truncatedCustomers.as("name", new String[]{"date_of_birth", "street", "zip_code", "city", "gender", "has_newsletter"});
        env.createTemporaryView("customers", namedCustomers);
        env.sqlQuery(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  COUNT(*) AS `number of customers`,\n        |  AVG(YEAR(date_of_birth)) AS `average birth year`\n        |FROM `customers`\n        |")).stripMargin()).execute().print();
        Table youngCustomers = env.from("customers").filter((Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"gender"}))).$((Seq)Nil$.MODULE$)).isNotNull()).filter(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"has_newsletter"}))).$((Seq)Nil$.MODULE$)).$eq$eq$eq(package$.MODULE$.boolean2Literal(true))).filter(package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date_of_birth"}))).$((Seq)Nil$.MODULE$)).$greater$eq(package$.MODULE$.localDate2Literal(LocalDate.parse("1980-01-01")))).select(new Expression[]{(Expression)package$.MODULE$.WithOperations(package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$)).upperCase(), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date_of_birth"}))).$((Seq)Nil$.MODULE$), (Expression)package$.MODULE$.WithOperations(package$.MODULE$.call(GettingStartedExample.AddressNormalizer.class, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"street"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zip_code"}))).$((Seq)Nil$.MODULE$), package$.MODULE$.FieldExpression(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"city"}))).$((Seq)Nil$.MODULE$)}))).as("address", new String[0])});
        try (CloseableIterator iterator = null;){
            iterator = youngCustomers.execute().collect();
            Set actualOutput = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter((Iterator)iterator).asScala()).toSet();
            Set expectedOutput = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row.of((Object[])new Object[]{"GUILLERMO SMITH", LocalDate.parse("1992-12-12"), "4081 VALLEY ROAD, 08540, NEW JERSEY"}), Row.of((Object[])new Object[]{"JOHN TURNER", LocalDate.parse("1982-10-02"), "2359 NEW STREET, 60605, CHICAGO"}), Row.of((Object[])new Object[]{"ELLEN ORTEGA", LocalDate.parse("1985-06-18"), "2448 RODNEY STREET, 85023, PHOENIX"})}));
            Set set = actualOutput;
            Set set2 = expectedOutput;
            if (!(set != null ? !set.equals(set2) : set2 != null)) {
                Predef$.MODULE$.println((Object)"SUCCESS!");
            } else {
                Predef$.MODULE$.println((Object)"FAILURE!");
            }
            return;
        }
    }

    private GettingStartedExample$() {
        MODULE$ = this;
    }
}

