/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.ConstantArgumentCount;
import org.apache.flink.table.types.inference.InputTypeStrategy;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

public final class InternalRowMergerFunction
extends ScalarFunction {
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().inputTypeStrategy(new InputTypeStrategy(){

            public ArgumentCount getArgumentCount() {
                return ConstantArgumentCount.of((int)2);
            }

            public Optional<List<DataType>> inferInputTypes(CallContext callContext, boolean throwOnFailure) {
                List args = callContext.getArgumentDataTypes();
                DataType arg0 = (DataType)args.get(0);
                DataType arg1 = (DataType)args.get(1);
                if (arg0.getLogicalType().getTypeRoot() != LogicalTypeRoot.ROW || arg1.getLogicalType().getTypeRoot() != LogicalTypeRoot.ROW) {
                    if (throwOnFailure) {
                        throw callContext.newValidationError("Two row arguments expected.", new Object[0]);
                    }
                    return Optional.empty();
                }
                return Optional.of(Arrays.asList((DataType)arg0.bridgedTo(RowData.class), (DataType)arg1.bridgedTo(RowData.class)));
            }

            public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
                return Collections.singletonList(Signature.of((Signature.Argument[])new Signature.Argument[]{Signature.Argument.of((String)"ROW"), Signature.Argument.of((String)"ROW")}));
            }
        }).outputTypeStrategy(callContext -> {
            List args = callContext.getArgumentDataTypes();
            ArrayList allFieldDataTypes = new ArrayList();
            allFieldDataTypes.addAll(((DataType)args.get(0)).getChildren());
            allFieldDataTypes.addAll(((DataType)args.get(1)).getChildren());
            DataTypes.Field[] fields = (DataTypes.Field[])IntStream.range(0, allFieldDataTypes.size()).mapToObj(i -> DataTypes.FIELD((String)("f" + i), (DataType)((DataType)allFieldDataTypes.get(i)))).toArray(DataTypes.Field[]::new);
            return Optional.of(DataTypes.ROW((DataTypes.Field[])fields).bridgedTo(RowData.class));
        }).build();
    }

    public RowData eval(RowData r1, RowData r2) {
        return new JoinedRowData(r1, r2);
    }
}

