/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.connectors;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.examples.java.connectors.ChangelogCsvFormat;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;

public final class ChangelogCsvFormatFactory
implements DeserializationFormatFactory {
    public static final ConfigOption<String> COLUMN_DELIMITER = ConfigOptions.key((String)"column-delimiter").stringType().defaultValue((Object)"|");

    public String factoryIdentifier() {
        return "changelog-csv";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(COLUMN_DELIMITER);
        return options;
    }

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        String columnDelimiter = (String)formatOptions.get(COLUMN_DELIMITER);
        return new ChangelogCsvFormat(columnDelimiter);
    }
}

