/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.basics;

import java.time.LocalDate;
import java.util.HashSet;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public final class GettingStartedExample {
    public static void main(String[] args) throws Exception {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
        TableEnvironment env = TableEnvironment.create((EnvironmentSettings)settings);
        Table rawCustomers = env.fromValues(new Object[]{Row.of((Object[])new Object[]{"Guillermo Smith", LocalDate.parse("1992-12-12"), "4081 Valley Road", "08540", "New Jersey", "m", true, 0, 78, 3}), Row.of((Object[])new Object[]{"Valeria Mendoza", LocalDate.parse("1970-03-28"), "1239  Rainbow Road", "90017", "Los Angeles", "f", true, 9, 39, 0}), Row.of((Object[])new Object[]{"Leann Holloway", LocalDate.parse("1989-05-21"), "2359 New Street", "97401", "Eugene", null, true, null, null, null}), Row.of((Object[])new Object[]{"Brandy Sanders", LocalDate.parse("1956-05-26"), "4891 Walkers-Ridge-Way", "73119", "Oklahoma City", "m", false, 9, 39, 0}), Row.of((Object[])new Object[]{"John Turner", LocalDate.parse("1982-10-02"), "2359 New Street", "60605", "Chicago", "m", true, 12, 39, 0}), Row.of((Object[])new Object[]{"Ellen Ortega", LocalDate.parse("1985-06-18"), "2448 Rodney STreet", "85023", "Phoenix", "f", true, 0, 78, 3})});
        Table truncatedCustomers = rawCustomers.select(new Expression[]{Expressions.withColumns((Object)Expressions.range((int)1, (int)7), (Object[])new Object[0])});
        Table namedCustomers = truncatedCustomers.as("name", new String[]{"date_of_birth", "street", "zip_code", "city", "gender", "has_newsletter"});
        env.createTemporaryView("customers", namedCustomers);
        env.sqlQuery("SELECT   COUNT(*) AS `number of customers`,   AVG(YEAR(date_of_birth)) AS `average birth year` FROM `customers`").execute().print();
        Table youngCustomers = env.from("customers").filter((Expression)Expressions.$((String)"gender").isNotNull()).filter((Expression)Expressions.$((String)"has_newsletter").isEqual((Object)true)).filter((Expression)Expressions.$((String)"date_of_birth").isGreaterOrEqual((Object)LocalDate.parse("1980-01-01"))).select(new Expression[]{(Expression)Expressions.$((String)"name").upperCase(), Expressions.$((String)"date_of_birth"), (Expression)Expressions.call(AddressNormalizer.class, (Object[])new Object[]{Expressions.$((String)"street"), Expressions.$((String)"zip_code"), Expressions.$((String)"city")}).as("address", new String[0])});
        try (CloseableIterator iterator = youngCustomers.execute().collect();){
            HashSet<Row> expectedOutput = new HashSet<Row>();
            expectedOutput.add(Row.of((Object[])new Object[]{"GUILLERMO SMITH", LocalDate.parse("1992-12-12"), "4081 VALLEY ROAD, 08540, NEW JERSEY"}));
            expectedOutput.add(Row.of((Object[])new Object[]{"JOHN TURNER", LocalDate.parse("1982-10-02"), "2359 NEW STREET, 60605, CHICAGO"}));
            expectedOutput.add(Row.of((Object[])new Object[]{"ELLEN ORTEGA", LocalDate.parse("1985-06-18"), "2448 RODNEY STREET, 85023, PHOENIX"}));
            HashSet actualOutput = new HashSet();
            iterator.forEachRemaining(actualOutput::add);
            if (actualOutput.equals(expectedOutput)) {
                System.out.println("SUCCESS!");
            } else {
                System.out.println("FAILURE!");
            }
        }
    }

    public static class AddressNormalizer
    extends ScalarFunction {
        public String eval(String street, String zipCode, String city) {
            return this.normalize(street) + ", " + this.normalize(zipCode) + ", " + this.normalize(city);
        }

        private String normalize(String s) {
            return s.toUpperCase().replaceAll("\\W", " ").replaceAll("\\s+", " ").trim();
        }
    }
}

