/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.basics;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.BatchTableEnvironment;
import org.apache.flink.table.expressions.Expression;

public class WordCountSQL {
    public static void main(String[] args) throws Exception {
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        BatchTableEnvironment tEnv = BatchTableEnvironment.create((ExecutionEnvironment)env);
        DataSource input = env.fromElements((Object[])new WC[]{new WC("Hello", 1L), new WC("Ciao", 1L), new WC("Hello", 1L)});
        tEnv.createTemporaryView("WordCount", (DataSet)input, new Expression[]{Expressions.$((String)"word"), Expressions.$((String)"frequency")});
        Table table = tEnv.sqlQuery("SELECT word, SUM(frequency) as frequency FROM WordCount GROUP BY word");
        DataSet result = tEnv.toDataSet(table, WC.class);
        result.print();
    }

    public static class WC {
        public String word;
        public long frequency;

        public WC() {
        }

        public WC(String word, long frequency) {
            this.word = word;
            this.frequency = frequency;
        }

        public String toString() {
            return "WC " + this.word + " " + this.frequency;
        }
    }
}

