/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.java.StreamTableEnvironment;

public class StreamSQLExample {
    public static void main(String[] args) throws Exception {
        StreamTableEnvironment tEnv;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        String planner = params.has("planner") ? params.get("planner") : "flink";
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        if (Objects.equals(planner, "blink")) {
            EnvironmentSettings settings = EnvironmentSettings.newInstance().useBlinkPlanner().inStreamingMode().build();
            tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env, (EnvironmentSettings)settings);
        } else if (Objects.equals(planner, "flink")) {
            tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        } else {
            System.err.println("The planner is incorrect. Please run 'StreamSQLExample --planner <planner>', where planner (it is either flink or blink, and the default is flink) indicates whether the example uses flink planner or blink planner.");
            return;
        }
        DataStreamSource orderA = env.fromCollection(Arrays.asList(new Order(1L, "beer", 3), new Order(1L, "diaper", 4), new Order(3L, "rubber", 2)));
        DataStreamSource orderB = env.fromCollection(Arrays.asList(new Order(2L, "pen", 3), new Order(2L, "rubber", 3), new Order(4L, "beer", 1)));
        Table tableA = tEnv.fromDataStream((DataStream)orderA, "user, product, amount");
        tEnv.registerDataStream("OrderB", (DataStream)orderB, "user, product, amount");
        Table result = tEnv.sqlQuery("SELECT * FROM " + tableA + " WHERE amount > 2 UNION ALL SELECT * FROM OrderB WHERE amount < 2");
        tEnv.toAppendStream(result, Order.class).print();
        env.execute();
    }

    public static class Order {
        public Long user;
        public String product;
        public int amount;

        public Order() {
        }

        public Order(Long user, String product, int amount) {
            this.user = user;
            this.product = product;
            this.amount = amount;
        }

        public String toString() {
            return "Order{user=" + this.user + ", product='" + this.product + '\'' + ", amount=" + this.amount + '}';
        }
    }
}

