/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.watermark.WatermarkHandlingResult;
import org.apache.flink.api.common.watermark.WatermarkHandlingStrategy;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.function.TwoInputBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.common.OutputCollector;
import org.apache.flink.datastream.impl.common.TimestampCollector;
import org.apache.flink.datastream.impl.context.DefaultNonPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.datastream.impl.context.UnsupportedProcessingTimeManager;
import org.apache.flink.datastream.impl.extension.eventtime.EventTimeExtensionImpl;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedTwoInputBroadcastStreamProcessFunction;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.asyncprocessing.operators.AbstractAsyncStateUdfStreamOperator;
import org.apache.flink.runtime.event.WatermarkEvent;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermark.AbstractInternalWatermarkDeclaration;
import org.apache.flink.streaming.runtime.watermark.extension.eventtime.EventTimeWatermarkHandler;
import org.apache.flink.util.Preconditions;

public class TwoInputBroadcastProcessOperator<IN1, IN2, OUT>
extends AbstractAsyncStateUdfStreamOperator<OUT, TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT>>
implements TwoInputStreamOperator<IN1, IN2, OUT>,
BoundedMultiInput {
    protected transient TimestampCollector<OUT> collector;
    protected transient DefaultRuntimeContext context;
    protected transient DefaultPartitionedContext<OUT> partitionedContext;
    protected transient NonPartitionedContext<OUT> nonPartitionedContext;
    protected transient Map<String, AbstractInternalWatermarkDeclaration<?>> watermarkDeclarationMap;
    protected transient EventTimeWatermarkHandler eventTimeWatermarkHandler;

    public TwoInputBroadcastProcessOperator(TwoInputBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction) {
        super(userFunction);
    }

    public void open() throws Exception {
        super.open();
        this.collector = this.getOutputCollector();
        StreamingRuntimeContext operatorContext = this.getRuntimeContext();
        TaskInfo taskInfo = operatorContext.getTaskInfo();
        this.context = new DefaultRuntimeContext(operatorContext.getJobInfo().getJobName(), operatorContext.getJobType(), taskInfo.getNumberOfParallelSubtasks(), taskInfo.getMaxNumberOfParallelSubtasks(), taskInfo.getTaskName(), taskInfo.getIndexOfThisSubtask(), taskInfo.getAttemptNumber(), (MetricGroup)operatorContext.getMetricGroup());
        this.watermarkDeclarationMap = this.config.getWatermarkDeclarations(this.getUserCodeClassloader()).stream().collect(Collectors.toMap(AbstractInternalWatermarkDeclaration::getIdentifier, Function.identity()));
        this.partitionedContext = new DefaultPartitionedContext(this.context, this::currentKey, this.getProcessorWithKey(), this.getProcessingTimeManager(), operatorContext, (OperatorStateStore)this.getOperatorStateBackend());
        this.nonPartitionedContext = this.getNonPartitionedContext();
        this.partitionedContext.setNonPartitionedContext(this.nonPartitionedContext);
        this.eventTimeWatermarkHandler = new EventTimeWatermarkHandler(2, this.output, this.timeServiceManager);
        if (this.userFunction instanceof EventTimeWrappedTwoInputBroadcastStreamProcessFunction) {
            ((EventTimeWrappedTwoInputBroadcastStreamProcessFunction)this.userFunction).initEventTimeExtension(this.getTimerService(), this.getEventTimeSupplier(), this.eventTimeWatermarkHandler);
        }
        ((TwoInputBroadcastStreamProcessFunction)this.userFunction).open(this.nonPartitionedContext);
    }

    public void processElement1(StreamRecord<IN1> element) throws Exception {
        this.collector.setTimestampFromStreamRecord(element);
        ((TwoInputBroadcastStreamProcessFunction)this.userFunction).processRecordFromNonBroadcastInput(element.getValue(), this.collector, this.partitionedContext);
    }

    public void processElement2(StreamRecord<IN2> element) throws Exception {
        this.collector.setTimestampFromStreamRecord(element);
        ((TwoInputBroadcastStreamProcessFunction)this.userFunction).processRecordFromBroadcastInput(element.getValue(), this.nonPartitionedContext);
    }

    public void processWatermark1Internal(WatermarkEvent watermark) throws Exception {
        WatermarkHandlingResult watermarkHandlingResultByUserFunction = ((TwoInputBroadcastStreamProcessFunction)this.userFunction).onWatermarkFromNonBroadcastInput(watermark.getWatermark(), this.collector, this.nonPartitionedContext);
        if (watermarkHandlingResultByUserFunction == WatermarkHandlingResult.PEEK && this.watermarkDeclarationMap.get(watermark.getWatermark().getIdentifier()).getDefaultHandlingStrategy() == WatermarkHandlingStrategy.FORWARD) {
            if (EventTimeExtensionImpl.isEventTimeExtensionWatermark(watermark.getWatermark())) {
                this.eventTimeWatermarkHandler.processWatermark(watermark.getWatermark(), 0);
            } else {
                this.output.emitWatermark(watermark);
            }
        }
    }

    public void processWatermark2Internal(WatermarkEvent watermark) throws Exception {
        WatermarkHandlingResult watermarkHandlingResultByUserFunction = ((TwoInputBroadcastStreamProcessFunction)this.userFunction).onWatermarkFromBroadcastInput(watermark.getWatermark(), this.collector, this.nonPartitionedContext);
        if (watermarkHandlingResultByUserFunction == WatermarkHandlingResult.PEEK && this.watermarkDeclarationMap.get(watermark.getWatermark().getIdentifier()).getDefaultHandlingStrategy() == WatermarkHandlingStrategy.FORWARD) {
            if (EventTimeExtensionImpl.isEventTimeExtensionWatermark(watermark.getWatermark())) {
                this.eventTimeWatermarkHandler.processWatermark(watermark.getWatermark(), 1);
            } else {
                this.output.emitWatermark(watermark);
            }
        }
    }

    protected TimestampCollector<OUT> getOutputCollector() {
        return new OutputCollector(this.output);
    }

    protected NonPartitionedContext<OUT> getNonPartitionedContext() {
        return new DefaultNonPartitionedContext<OUT>(this.context, this.partitionedContext, this.collector, false, null, this.output, this.watermarkDeclarationMap);
    }

    public void endInput(int inputId) throws Exception {
        Preconditions.checkState((inputId >= 1 && inputId <= 2 ? 1 : 0) != 0);
        if (inputId == 1) {
            ((TwoInputBroadcastStreamProcessFunction)this.userFunction).endNonBroadcastInput(this.nonPartitionedContext);
        } else {
            ((TwoInputBroadcastStreamProcessFunction)this.userFunction).endBroadcastInput(this.nonPartitionedContext);
        }
    }

    protected Object currentKey() {
        throw new UnsupportedOperationException("The key is only defined for keyed operator");
    }

    protected BiConsumer<Runnable, Object> getProcessorWithKey() {
        if (this.isAsyncKeyOrderedProcessingEnabled()) {
            return (r, k) -> this.asyncProcessWithKey(k, r::run);
        }
        return (r, k) -> {
            Object oldKey = this.currentKey();
            try {
                r.run();
            }
            finally {
                this.setCurrentKey(oldKey);
            }
        };
    }

    protected ProcessingTimeManager getProcessingTimeManager() {
        return UnsupportedProcessingTimeManager.INSTANCE;
    }

    public void close() throws Exception {
        super.close();
        ((TwoInputBroadcastStreamProcessFunction)this.userFunction).close();
    }

    public boolean isAsyncKeyOrderedProcessingEnabled() {
        return false;
    }

    protected InternalTimerService<VoidNamespace> getTimerService() {
        return null;
    }

    protected Supplier<Long> getEventTimeSupplier() {
        return () -> this.eventTimeWatermarkHandler.getLastEmitWatermark();
    }
}

