/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.postgres.source.utils;

import io.debezium.relational.Column;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

public class PostgresTypeUtils {
    private static final String PG_SMALLSERIAL = "smallserial";
    private static final String PG_SERIAL = "serial";
    private static final String PG_BIGSERIAL = "bigserial";
    private static final String PG_BYTEA = "bytea";
    private static final String PG_BYTEA_ARRAY = "_bytea";
    private static final String PG_SMALLINT = "int2";
    private static final String PG_SMALLINT_ARRAY = "_int2";
    private static final String PG_INTEGER = "int4";
    private static final String PG_INTEGER_ARRAY = "_int4";
    private static final String PG_BIGINT = "int8";
    private static final String PG_BIGINT_ARRAY = "_int8";
    private static final String PG_REAL = "float4";
    private static final String PG_REAL_ARRAY = "_float4";
    private static final String PG_DOUBLE_PRECISION = "float8";
    private static final String PG_DOUBLE_PRECISION_ARRAY = "_float8";
    private static final String PG_NUMERIC = "numeric";
    private static final String PG_NUMERIC_ARRAY = "_numeric";
    private static final String PG_BOOLEAN = "bool";
    private static final String PG_BOOLEAN_ARRAY = "_bool";
    private static final String PG_TIMESTAMP = "timestamp";
    private static final String PG_TIMESTAMP_ARRAY = "_timestamp";
    private static final String PG_TIMESTAMPTZ = "timestamptz";
    private static final String PG_TIMESTAMPTZ_ARRAY = "_timestamptz";
    private static final String PG_DATE = "date";
    private static final String PG_DATE_ARRAY = "_date";
    private static final String PG_TIME = "time";
    private static final String PG_TIME_ARRAY = "_time";
    private static final String PG_TEXT = "text";
    private static final String PG_TEXT_ARRAY = "_text";
    private static final String PG_CHAR = "bpchar";
    private static final String PG_CHAR_ARRAY = "_bpchar";
    private static final String PG_CHARACTER = "character";
    private static final String PG_CHARACTER_ARRAY = "_character";
    private static final String PG_CHARACTER_VARYING = "varchar";
    private static final String PG_CHARACTER_VARYING_ARRAY = "_varchar";

    public static DataType fromDbzColumn(Column column) {
        DataType dataType = PostgresTypeUtils.convertFromColumn(column);
        if (column.isOptional()) {
            return dataType;
        }
        return (DataType)dataType.notNull();
    }

    private static DataType convertFromColumn(Column column) {
        String typeName = column.typeName();
        int precision = column.length();
        int scale = column.scale().orElse(0);
        switch (typeName) {
            case "bool": {
                return DataTypes.BOOLEAN();
            }
            case "_bool": {
                return DataTypes.ARRAY((DataType)DataTypes.BOOLEAN());
            }
            case "bytea": {
                return DataTypes.BYTES();
            }
            case "_bytea": {
                return DataTypes.ARRAY((DataType)DataTypes.BYTES());
            }
            case "int2": 
            case "smallserial": {
                return DataTypes.SMALLINT();
            }
            case "_int2": {
                return DataTypes.ARRAY((DataType)DataTypes.SMALLINT());
            }
            case "int4": 
            case "serial": {
                return DataTypes.INT();
            }
            case "_int4": {
                return DataTypes.ARRAY((DataType)DataTypes.INT());
            }
            case "int8": 
            case "bigserial": {
                return DataTypes.BIGINT();
            }
            case "_int8": {
                return DataTypes.ARRAY((DataType)DataTypes.BIGINT());
            }
            case "float4": {
                return DataTypes.FLOAT();
            }
            case "_float4": {
                return DataTypes.ARRAY((DataType)DataTypes.FLOAT());
            }
            case "float8": {
                return DataTypes.DOUBLE();
            }
            case "_float8": {
                return DataTypes.ARRAY((DataType)DataTypes.DOUBLE());
            }
            case "numeric": {
                if (precision > 0) {
                    return DataTypes.DECIMAL((int)precision, (int)scale);
                }
                return DataTypes.DECIMAL((int)38, (int)18);
            }
            case "_numeric": {
                if (precision > 0) {
                    return DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)precision, (int)scale));
                }
                return DataTypes.ARRAY((DataType)DataTypes.DECIMAL((int)38, (int)18));
            }
            case "bpchar": 
            case "character": {
                return DataTypes.CHAR((int)precision);
            }
            case "_bpchar": 
            case "_character": {
                return DataTypes.ARRAY((DataType)DataTypes.CHAR((int)precision));
            }
            case "varchar": {
                return DataTypes.VARCHAR((int)precision);
            }
            case "_varchar": {
                return DataTypes.ARRAY((DataType)DataTypes.VARCHAR((int)precision));
            }
            case "text": {
                return DataTypes.STRING();
            }
            case "_text": {
                return DataTypes.ARRAY((DataType)DataTypes.STRING());
            }
            case "timestamp": {
                return DataTypes.TIMESTAMP((int)scale);
            }
            case "_timestamp": {
                return DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP((int)scale));
            }
            case "timestamptz": {
                return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)scale);
            }
            case "_timestamptz": {
                return DataTypes.ARRAY((DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)scale));
            }
            case "time": {
                return DataTypes.TIME((int)scale);
            }
            case "_time": {
                return DataTypes.ARRAY((DataType)DataTypes.TIME((int)scale));
            }
            case "date": {
                return DataTypes.DATE();
            }
            case "_date": {
                return DataTypes.ARRAY((DataType)DataTypes.DATE());
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support Postgres type '%s' yet", typeName));
    }
}

