/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.event;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.event.AlterColumnTypeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.runtime.serializer.MapSerializer;
import org.apache.flink.cdc.runtime.serializer.StringSerializer;
import org.apache.flink.cdc.runtime.serializer.TableIdSerializer;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.schema.DataTypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class AlterColumnTypeEventSerializer
extends TypeSerializerSingleton<AlterColumnTypeEvent> {
    private static final long serialVersionUID = 1L;
    public static final AlterColumnTypeEventSerializer INSTANCE = new AlterColumnTypeEventSerializer();
    private final TableIdSerializer tableIdSerializer = TableIdSerializer.INSTANCE;
    private final MapSerializer<String, DataType> typeMapSerializer = new MapSerializer<String, DataType>(StringSerializer.INSTANCE, new DataTypeSerializer());

    public boolean isImmutableType() {
        return false;
    }

    public AlterColumnTypeEvent createInstance() {
        return new AlterColumnTypeEvent(TableId.tableId((String)"unknown"), Collections.emptyMap());
    }

    public AlterColumnTypeEvent copy(AlterColumnTypeEvent from) {
        return new AlterColumnTypeEvent(from.tableId(), this.typeMapSerializer.copy(from.getTypeMapping()), this.typeMapSerializer.copy(from.getOldTypeMapping()));
    }

    public AlterColumnTypeEvent copy(AlterColumnTypeEvent from, AlterColumnTypeEvent reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(AlterColumnTypeEvent record, DataOutputView target) throws IOException {
        this.tableIdSerializer.serialize(record.tableId(), target);
        this.typeMapSerializer.serialize(record.getTypeMapping(), target);
        this.typeMapSerializer.serialize(record.getOldTypeMapping(), target);
    }

    public AlterColumnTypeEvent deserialize(DataInputView source) throws IOException {
        return new AlterColumnTypeEvent(this.tableIdSerializer.deserialize(source), (Map)this.typeMapSerializer.deserialize(source), (Map)this.typeMapSerializer.deserialize(source));
    }

    public AlterColumnTypeEvent deserialize(AlterColumnTypeEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize(this.deserialize(source), target);
    }

    public TypeSerializerSnapshot<AlterColumnTypeEvent> snapshotConfiguration() {
        return new AlterColumnTypeEventSerializerSnapshot();
    }

    public static final class AlterColumnTypeEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<AlterColumnTypeEvent> {
        public AlterColumnTypeEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

