/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;

public final class EnumSerializer<T extends Enum<T>>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> enumClass;
    private Map<T, Integer> valueToOrdinal;
    private T[] values;

    public EnumSerializer(Class<T> enumClass) {
        this(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    private EnumSerializer(Class<T> enumClass, T[] enumValues) {
        this.enumClass = (Class)Preconditions.checkNotNull(enumClass);
        this.values = (Enum[])Preconditions.checkNotNull(enumValues);
        Preconditions.checkArgument((boolean)Enum.class.isAssignableFrom(enumClass), (String)"not an enum", (Object[])new Object[0]);
        Preconditions.checkArgument((this.values.length > 0 ? 1 : 0) != 0, (String)"cannot use an empty enum", (Object[])new Object[0]);
        this.valueToOrdinal = new EnumMap<T, Integer>(this.enumClass);
        int i = 0;
        for (T value : this.values) {
            this.valueToOrdinal.put(value, i++);
        }
    }

    public boolean isImmutableType() {
        return true;
    }

    public EnumSerializer<T> duplicate() {
        return this;
    }

    public T createInstance() {
        Preconditions.checkState((this.values != null ? 1 : 0) != 0);
        return this.values[0];
    }

    public T copy(T from) {
        return from;
    }

    public T copy(T from, T reuse) {
        return from;
    }

    public int getLength() {
        return 4;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        target.writeInt(this.valueToOrdinal.get(record).intValue());
    }

    public T deserialize(DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 4);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EnumSerializer) {
            EnumSerializer other = (EnumSerializer)((Object)obj);
            return other.enumClass == this.enumClass && Arrays.equals(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        return this.enumClass.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.values == null) {
            this.values = (Enum[])this.enumClass.getEnumConstants();
            this.valueToOrdinal = new EnumMap<T, Integer>(this.enumClass);
            int i = 0;
            for (T value : this.values) {
                this.valueToOrdinal.put(value, i++);
            }
        }
    }

    public EnumSerializerSnapshot<T> snapshotConfiguration() {
        return new EnumSerializerSnapshot(this.enumClass, this.values);
    }

    @VisibleForTesting
    T[] getValues() {
        return this.values;
    }

    @VisibleForTesting
    Map<T, Integer> getValueToOrdinal() {
        return this.valueToOrdinal;
    }

    public String toString() {
        return "EnumSerializer{enumClass=" + this.enumClass + ", values=" + Arrays.toString(this.values) + '}';
    }

    public static final class EnumSerializerSnapshot<T extends Enum<T>>
    implements TypeSerializerSnapshot<T> {
        private static final int CURRENT_VERSION = 3;
        private T[] previousEnums;
        private Class<T> enumClass;

        public EnumSerializerSnapshot() {
        }

        EnumSerializerSnapshot(Class<T> enumClass, T[] enums) {
            this.enumClass = (Class)Preconditions.checkNotNull(enumClass);
            this.previousEnums = (Enum[])Preconditions.checkNotNull(enums);
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            Preconditions.checkState((this.enumClass != null ? 1 : 0) != 0, (Object)"Enum class can not be null.");
            out.writeUTF(this.enumClass.getName());
            out.writeInt(this.previousEnums.length);
            for (T enumConstant : this.previousEnums) {
                out.writeUTF(((Enum)enumConstant).name());
            }
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.enumClass = InstantiationUtil.resolveClassByName((DataInputView)in, (ClassLoader)userCodeClassLoader);
            int numEnumConstants = in.readInt();
            Enum[] previousEnums = (Enum[])Array.newInstance(this.enumClass, numEnumConstants);
            for (int i = 0; i < numEnumConstants; ++i) {
                String enumName = in.readUTF();
                try {
                    previousEnums[i] = Enum.valueOf(this.enumClass, enumName);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Could not create a restore serializer for enum " + this.enumClass + ". Probably because an enum value was removed.");
                }
            }
            this.previousEnums = previousEnums;
        }

        public TypeSerializer<T> restoreSerializer() {
            Preconditions.checkState((this.enumClass != null ? 1 : 0) != 0, (Object)"Enum class can not be null.");
            return new EnumSerializer(this.enumClass, (Enum[])this.previousEnums);
        }

        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            if (!(newSerializer instanceof EnumSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            EnumSerializer newEnumSerializer = (EnumSerializer)newSerializer;
            if (!this.enumClass.equals(newEnumSerializer.enumClass)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            Object[] currentEnums = (Enum[])this.enumClass.getEnumConstants();
            if (Arrays.equals(this.previousEnums, currentEnums)) {
                return TypeSerializerSchemaCompatibility.compatibleAsIs();
            }
            LinkedHashSet<Enum> reconfiguredEnumSet = new LinkedHashSet<Enum>(Arrays.asList(this.previousEnums));
            reconfiguredEnumSet.addAll(Arrays.asList(currentEnums));
            Enum[] reconfiguredEnums = reconfiguredEnumSet.toArray((Enum[])Array.newInstance(this.enumClass, reconfiguredEnumSet.size()));
            EnumSerializer reconfiguredSerializer = new EnumSerializer(this.enumClass, reconfiguredEnums);
            return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer(reconfiguredSerializer);
        }
    }
}

