/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.runtime.operators.transform.exceptions.TransformException;

public class ProjectionColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Column column;
    private final String expression;
    private final String scriptExpression;
    private final List<String> originalColumnNames;
    private final Map<String, String> columnNameMap;

    public ProjectionColumn(Column column, String expression, String scriptExpression, List<String> originalColumnNames, Map<String, String> columnNameMap) {
        this.column = column;
        this.expression = expression;
        this.scriptExpression = scriptExpression;
        this.originalColumnNames = originalColumnNames;
        this.columnNameMap = columnNameMap;
    }

    public ProjectionColumn copy() {
        return new ProjectionColumn(this.column.copy(this.column.getName()), this.expression, this.scriptExpression, new ArrayList<String>(this.originalColumnNames), new HashMap<String, String>(this.columnNameMap));
    }

    public Column getColumn() {
        return this.column;
    }

    public String getColumnName() {
        return this.column.getName();
    }

    public DataType getDataType() {
        return this.column.getType();
    }

    public String getScriptExpression() {
        return this.scriptExpression;
    }

    public List<String> getOriginalColumnNames() {
        return this.originalColumnNames;
    }

    public Map<String, String> getColumnNameMap() {
        return this.columnNameMap;
    }

    public String getColumnNameMapAsString() {
        return TransformException.prettyPrintColumnNameMap(this.getColumnNameMap());
    }

    public boolean isValidTransformedProjectionColumn() {
        return !StringUtils.isNullOrWhitespaceOnly((String)this.scriptExpression);
    }

    public static ProjectionColumn ofForwarded(Column column, String mappedColumnName) {
        String name = column.getName();
        Map<String, String> columnNameMap = Collections.singletonMap(name, mappedColumnName);
        return new ProjectionColumn(column, name, mappedColumnName, Collections.singletonList(name), columnNameMap);
    }

    public static ProjectionColumn ofAliased(Column column, String newName, String mappedColumnName) {
        String originalName = column.getName();
        Map<String, String> columnNameMap = Collections.singletonMap(originalName, mappedColumnName);
        return new ProjectionColumn(column.copy(newName), originalName, mappedColumnName, Collections.singletonList(originalName), columnNameMap);
    }

    public static ProjectionColumn ofCalculated(String columnName, DataType dataType, String expression, String scriptExpression, List<String> originalColumnNames, Map<String, String> columnNameMap) {
        return new ProjectionColumn((Column)Column.physicalColumn((String)columnName, (DataType)dataType), expression, scriptExpression, originalColumnNames, columnNameMap);
    }

    public String toString() {
        return "ProjectionColumn{column=" + this.column + ", expression='" + this.expression + '\'' + ", scriptExpression='" + this.scriptExpression + '\'' + ", originalColumnNames=" + this.originalColumnNames + ", columnNameMap=" + this.columnNameMap + '}';
    }
}

