/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.transform;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.source.SupportedMetadataColumn;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.runtime.operators.transform.PostTransformChangeInfo;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumn;
import org.apache.flink.cdc.runtime.operators.transform.ProjectionColumnProcessor;
import org.apache.flink.cdc.runtime.operators.transform.TransformContext;
import org.apache.flink.cdc.runtime.operators.transform.UserDefinedFunctionDescriptor;
import org.apache.flink.cdc.runtime.parser.TransformParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformProjectionProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TransformProjectionProcessor.class);
    private final PostTransformChangeInfo changeInfo;
    private final String projectionExpression;
    private final String timezone;
    private final List<UserDefinedFunctionDescriptor> udfDescriptors;
    private final List<Object> udfFunctionInstances;
    private final List<ProjectionColumnProcessor> columnProcessors;
    private final SupportedMetadataColumn[] supportedMetadataColumns;
    private final Map<String, SupportedMetadataColumn> supportedMetadataColumnsMap;

    public TransformProjectionProcessor(PostTransformChangeInfo changeInfo, String projectionExpression, String timezone, List<UserDefinedFunctionDescriptor> udfDescriptors, List<Object> udfFunctionInstances, SupportedMetadataColumn[] supportedMetadataColumns) {
        this.changeInfo = changeInfo;
        this.projectionExpression = projectionExpression;
        this.timezone = timezone;
        this.udfDescriptors = udfDescriptors;
        this.udfFunctionInstances = udfFunctionInstances;
        this.supportedMetadataColumns = supportedMetadataColumns;
        HashMap<String, SupportedMetadataColumn> supportedMetadataColumnsMap = new HashMap<String, SupportedMetadataColumn>();
        for (SupportedMetadataColumn supportedMetadataColumn : supportedMetadataColumns) {
            supportedMetadataColumnsMap.put(supportedMetadataColumn.getName(), supportedMetadataColumn);
        }
        this.supportedMetadataColumnsMap = supportedMetadataColumnsMap;
        this.columnProcessors = this.createProjectionColumnProcessors();
    }

    public Object[] project(Object[] rowData, TransformContext context) {
        return this.columnProcessors.stream().map(processor -> processor.evaluate(rowData, context)).toArray();
    }

    private List<ProjectionColumnProcessor> createProjectionColumnProcessors() {
        Preconditions.checkNotNull((Object)this.changeInfo, (String)"Projection column processors could only be created if changeInfo is available.");
        List<ProjectionColumn> projectionColumns = TransformParser.generateProjectionColumns(this.projectionExpression, this.changeInfo.getPreTransformedSchema().getColumns(), this.udfDescriptors, this.supportedMetadataColumns);
        List<ProjectionColumnProcessor> columnProcessors = projectionColumns.stream().map(column -> ProjectionColumnProcessor.of(this.changeInfo, column, this.timezone, this.udfDescriptors, this.udfFunctionInstances, this.supportedMetadataColumnsMap)).collect(Collectors.toList());
        LOG.info("Successfully created projection column processors cache.");
        LOG.info("Cached results: {}", columnProcessors);
        return columnProcessors;
    }
}

